/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.shared;

import dev.rollczi.litecommands.shared.BiMap;
import dev.rollczi.litecommands.shared.BiMapConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class BiHashMap<K1, K2, V>
implements BiMap<K1, K2, V> {
    private final Map<K1, Map<K2, V>> nativeMap;

    public BiHashMap(BiMap<K1, K2, V> biMap) {
        this(biMap, biMap.flatSize());
    }

    public BiHashMap(BiMap<K1, K2, V> biMap, int initialCapacity) {
        this(initialCapacity);
        biMap.forEach((k1, k2, v) -> this.put(k1, k2, v));
    }

    public BiHashMap() {
        this(16);
    }

    public BiHashMap(int initialCapacity) {
        this.nativeMap = new HashMap<K1, Map<K2, V>>(initialCapacity);
    }

    @Override
    public void put(K1 key1, K2 key2, V value) {
        Map map = this.nativeMap.computeIfAbsent(key1, k -> new HashMap());
        map.put(key2, value);
    }

    @Override
    public V get(K1 key1, K2 key2) {
        Map<K2, V> map = this.nativeMap.get(key1);
        if (map == null) {
            return null;
        }
        return map.get(key2);
    }

    @Override
    public V remove(K1 key1, K2 key2) {
        Map<K2, V> map = this.nativeMap.get(key1);
        if (map == null) {
            return null;
        }
        return map.remove(key2);
    }

    @Override
    public boolean containsKey(K1 key1, K2 key2) {
        Map<K2, V> map = this.nativeMap.get(key1);
        if (map == null) {
            return false;
        }
        return map.containsKey(key2);
    }

    @Override
    public void forEach(BiMapConsumer<K1, K2, V> consumer) {
        this.nativeMap.forEach((? super K k1, ? super V map) -> map.forEach((? super K k2, ? super V v) -> consumer.accept(k1, k2, v)));
    }

    @Override
    public int size() {
        return this.nativeMap.values().stream().mapToInt(Map::size).sum();
    }

    @Override
    public int flatSize() {
        return this.nativeMap.size();
    }

    @Override
    public V computeIfAbsent(K1 k1, K2 k2, BiFunction<K1, K2, V> function) {
        Map map = this.nativeMap.computeIfAbsent(k1, k -> new HashMap());
        return (V)map.computeIfAbsent(k2, k -> function.apply(k1, k2));
    }
}

