/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.message;

import dev.rollczi.litecommands.shared.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;

public class MessageKey<CONTEXT> {
    private final String name;
    private final Function<CONTEXT, Object> defaultMessage;
    private final List<MessageKey<CONTEXT>> fallbacks;

    public MessageKey(String name, Function<CONTEXT, Object> defaultMessage) {
        this(name, defaultMessage, Collections.emptyList());
    }

    private MessageKey(String name, Function<CONTEXT, Object> defaultMessage, List<MessageKey<CONTEXT>> fallbacks) {
        this.name = name;
        this.defaultMessage = defaultMessage;
        this.fallbacks = fallbacks;
    }

    public String getName() {
        return this.name;
    }

    public List<MessageKey<CONTEXT>> getFallbacks() {
        return this.fallbacks;
    }

    public Object getDefaultMessage(CONTEXT context) {
        return this.defaultMessage.apply(context);
    }

    @SafeVarargs
    @ApiStatus.Experimental
    public final MessageKey<CONTEXT> withFallbacks(MessageKey<CONTEXT> ... fallbacks) {
        return this.withFallbacks(Arrays.asList(fallbacks));
    }

    @ApiStatus.Experimental
    public MessageKey<CONTEXT> withFallbacks(List<MessageKey<CONTEXT>> fallbacks) {
        Preconditions.notNull(fallbacks, "fallbacks");
        Preconditions.notEmpty(fallbacks, "fallbacks");
        return new MessageKey<CONTEXT>(this.name, this.defaultMessage, Collections.unmodifiableList(fallbacks));
    }

    @SafeVarargs
    public static <CONTEXT> MessageKey<CONTEXT> of(String name, Object defaultMessage, MessageKey<CONTEXT> ... fallbacks) {
        return MessageKey.of(name, (CONTEXT context) -> defaultMessage, fallbacks);
    }

    @SafeVarargs
    public static <CONTEXT> MessageKey<CONTEXT> of(String name, Function<CONTEXT, Object> defaultMessage, MessageKey<CONTEXT> ... fallbacks) {
        Preconditions.notNull(name, "name");
        Preconditions.notNull(defaultMessage, "defaultMessage");
        List<MessageKey<CONTEXT>> fallbacksList = fallbacks == null || fallbacks.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(fallbacks));
        return new MessageKey<CONTEXT>(name, defaultMessage, fallbacksList);
    }
}

