/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.context;

import dev.rollczi.litecommands.context.ContextResult;
import dev.rollczi.litecommands.requirement.RequirementCondition;
import dev.rollczi.litecommands.requirement.RequirementResult;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextCompletedResult<T>
implements ContextResult<T>,
RequirementResult<T> {
    @Nullable
    private final Supplier<T> result;
    private final List<RequirementCondition> conditions;
    private final Object error;

    ContextCompletedResult(@Nullable Supplier<T> result, Object error, List<RequirementCondition> conditions) {
        this.result = result;
        this.error = error;
        this.conditions = conditions;
    }

    @Override
    @NotNull
    public T getSuccess() {
        if (this.result == null) {
            throw new IllegalStateException("Cannot get success result from failed result");
        }
        return this.result.get();
    }

    @Override
    @NotNull
    public Object getFailedReason() {
        return this.error;
    }

    @Override
    @NotNull
    public List<RequirementCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public boolean isFailed() {
        return this.error != null;
    }

    @Override
    public boolean isSuccessful() {
        return this.result != null;
    }

    @Override
    public boolean isSuccessfulNull() {
        return false;
    }

    @Override
    @ApiStatus.Experimental
    public <R> ContextResult<R> map(Function<T, R> mapper) {
        if (this.isFailed()) {
            return this;
        }
        return ContextResult.ok(() -> mapper.apply(this.getSuccess()));
    }

    @Override
    public ContextResult<T> mapFailure(Function<Object, ContextResult<T>> mapper) {
        if (this.isFailed()) {
            return mapper.apply(this.error);
        }
        return this;
    }

    @Override
    @ApiStatus.Experimental
    public <R> ContextResult<R> flatMap(Function<T, ContextResult<R>> mapper) {
        if (this.isFailed()) {
            return ContextResult.error(this.error);
        }
        return mapper.apply(this.getSuccess());
    }

    @Override
    public ContextCompletedResult<T> whenSuccessful(Consumer<T> action) {
        if (this.isSuccessful()) {
            action.accept(this.getSuccess());
        }
        return this;
    }

    @Override
    public ContextCompletedResult<T> whenFailed(Consumer<Object> action) {
        if (this.isFailed()) {
            action.accept(this.error);
        }
        return this;
    }

    public static <T> ContextCompletedResult<T> ok(Supplier<T> supplier) {
        return new ContextCompletedResult<T>(supplier, null, Collections.emptyList());
    }

    public static <T> ContextCompletedResult<T> error(Object error) {
        return new ContextCompletedResult<T>(null, error, Collections.emptyList());
    }

    @ApiStatus.Experimental
    public static <T> ContextCompletedResult<T> conditional(Supplier<T> supplier, List<RequirementCondition> conditions) {
        return new ContextCompletedResult<T>(supplier, null, Collections.unmodifiableList(conditions));
    }

    @Override
    public CompletableFuture<ContextCompletedResult<T>> asFuture() {
        return CompletableFuture.completedFuture(this);
    }
}

