/*
 * Decompiled with CFR 0.152.
 */
package de.exlll.configlib;

import de.exlll.configlib.ConfigurationElements;
import de.exlll.configlib.ConfigurationException;
import de.exlll.configlib.ConfigurationProperties;
import de.exlll.configlib.FieldExtractors;
import de.exlll.configlib.Reflect;
import de.exlll.configlib.TypeSerializer;
import de.exlll.configlib.Validator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class ConfigurationSerializer<T>
extends TypeSerializer<T, ConfigurationElements.FieldElement> {
    private final T defaultInstance = this.newDefaultInstance();

    ConfigurationSerializer(Class<T> configurationType, ConfigurationProperties properties) {
        super(Validator.requireConfigurationClass(configurationType), properties);
    }

    @Override
    public T deserialize(Map<?, ?> serializedConfiguration) {
        Object[] deserializedElements = this.deserializeConfigurationElements(serializedConfiguration);
        List<ConfigurationElements.FieldElement> elements = this.elements();
        T result = this.newDefaultInstance();
        for (int i = 0; i < deserializedElements.length; ++i) {
            ConfigurationElements.FieldElement fieldElement = elements.get(i);
            Reflect.setValue(fieldElement.element(), result, deserializedElements[i]);
        }
        return (T)this.postProcessor.apply(result);
    }

    @Override
    protected void requireSerializableElements() {
        if (this.serializers.isEmpty()) {
            String msg = String.format("Configuration class '%s' does not contain an (de-)serializable fields.", this.type.getSimpleName());
            throw new ConfigurationException(msg);
        }
    }

    @Override
    protected String baseDeserializeExceptionMessage(ConfigurationElements.FieldElement element, Object value) {
        return String.format("Deserialization of value '%s' with type '%s' for field '%s' failed.", value, value.getClass(), element.element());
    }

    @Override
    protected List<ConfigurationElements.FieldElement> elements() {
        return FieldExtractors.CONFIGURATION.extract(this.type).filter(this.properties.getFieldFilter()).map(ConfigurationElements.FieldElement::new).collect(Collectors.toList());
    }

    @Override
    T newDefaultInstance() {
        return Reflect.callNoParamConstructor(this.type);
    }

    Class<T> getConfigurationType() {
        return this.type;
    }

    @Override
    protected Object getDefaultValueOf(ConfigurationElements.FieldElement element) {
        return Reflect.getValue(element.element(), this.defaultInstance);
    }
}

