/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.teleport;

import co.crystaldev.alpinecore.event.ServerTickEvent;
import co.crystaldev.alpinecore.framework.teleport.TeleportContext;
import co.crystaldev.alpinecore.framework.teleport.TeleportHandler;
import co.crystaldev.alpinecore.framework.teleport.TeleportManager;
import co.crystaldev.alpinecore.framework.teleport.TeleportTask;
import co.crystaldev.alpinecore.util.Messaging;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class TeleportListener
implements Listener {
    private final TeleportManager manager;
    private final Map<Player, TeleportTask> tasks;

    @EventHandler
    public void onServerTick(ServerTickEvent event) {
        if (this.tasks.isEmpty()) {
            return;
        }
        TeleportHandler handler = this.manager.getTeleportHandler();
        Iterator<Map.Entry<Player, TeleportTask>> iterator = this.tasks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Player, TeleportTask> next = iterator.next();
            Player player = next.getKey();
            TeleportTask task = next.getValue();
            int ticksRemaining = task.tick();
            if (!task.getOrigin().getWorld().equals((Object)player.getWorld())) {
                this.manager.cancel(player);
                iterator.remove();
                continue;
            }
            TeleportContext context = null;
            boolean removed = false;
            if (ticksRemaining <= 0) {
                removed = true;
                iterator.remove();
                context = task.createContext(true);
                task.getCallbacks().getOnTeleport().accept(context);
                handler.onTeleport(context);
            } else if (ticksRemaining % 20 == 0) {
                context = task.createContext(false);
                task.getCallbacks().getOnCountdown().accept(context);
                handler.onCountdown(context);
            }
            if (context == null) continue;
            task.apply(context);
            Messaging.send((CommandSender)player, context.messageType(), context.message());
            if (!context.isCancelled() || removed) continue;
            this.manager.cancel(context.player());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!this.tasks.containsKey(player)) {
            return;
        }
        TeleportHandler handler = this.manager.getTeleportHandler();
        TeleportTask task = this.tasks.get(player);
        TeleportContext context = task.createContext(false);
        task.getCallbacks().getOnDamage().accept(context);
        handler.onDamage(context);
        task.apply(context);
        Messaging.send((CommandSender)context.player(), context.messageType(), context.message());
        if (context.isCancelled()) {
            this.manager.cancel(player);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        TeleportTask task;
        Player player = event.getPlayer();
        if (!this.tasks.containsKey(player)) {
            return;
        }
        TeleportHandler handler = this.manager.getTeleportHandler();
        TeleportContext context = task.createContext(!(task = this.tasks.get(player)).canMove());
        if (task.getTicksToTeleport() < 0) {
            return;
        }
        if (TeleportListener.checkDistance(event.getTo(), task.getOrigin(), task.getMovementThreshold())) {
            return;
        }
        task.getCallbacks().getOnMove().accept(context);
        handler.onMove(context);
        task.apply(context);
        Messaging.send((CommandSender)context.player(), context.messageType(), context.message());
        if (context.isCancelled() || !task.canMove()) {
            this.manager.cancel(player);
        }
    }

    @EventHandler
    public void onPlayerDisconnect(PlayerQuitEvent event) {
        this.manager.cancel(event.getPlayer());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkDistance(@NotNull Location to, @NotNull Location from, double threshold) {
        double d;
        if (!(Math.abs(from.getY() - to.getY()) < 1.25)) return false;
        double value = from.getX() - to.getX();
        double d2 = value * value;
        value = from.getZ() - to.getZ();
        if (!(d2 + d * value < threshold * threshold)) return false;
        return true;
    }

    @Generated
    public TeleportListener(TeleportManager manager, Map<Player, TeleportTask> tasks) {
        this.manager = manager;
        this.tasks = tasks;
    }
}

