/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.adventure.bukkit.platform;

import dev.rollczi.litecommands.adventure.AdventureAudienceProvider;
import dev.rollczi.litecommands.adventure.bukkit.platform.RawTextAudience;
import dev.rollczi.litecommands.identifier.Identifier;
import dev.rollczi.litecommands.invocation.Invocation;
import dev.rollczi.litecommands.platform.PlatformReceiver;
import dev.rollczi.litecommands.platform.PlatformSender;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.AudienceProvider;

class AdventurePlatformAudienceProvider<SENDER>
implements AdventureAudienceProvider<SENDER> {
    private final AudienceProvider audienceProvider;

    public AdventurePlatformAudienceProvider(AudienceProvider audienceProvider) {
        this.audienceProvider = audienceProvider;
    }

    @Override
    public Audience sender(Invocation<SENDER> invocation) {
        SENDER sender = invocation.sender();
        if (sender instanceof Audience) {
            return (Audience)sender;
        }
        PlatformSender platformSender = invocation.platformSender();
        Identifier identifier = platformSender.getIdentifier();
        if (identifier.equals(Identifier.CONSOLE)) {
            return this.audienceProvider.console();
        }
        Optional<UUID> uuidOptional = identifier.getIdentifier(UUID.class);
        if (uuidOptional.isPresent()) {
            return this.audienceProvider.player(uuidOptional.get());
        }
        if (invocation.platformSender() instanceof PlatformReceiver) {
            return new RawTextAudience((PlatformReceiver)((Object)invocation.platformSender()));
        }
        throw new IllegalArgumentException("Unsupported command sender type: " + sender.getClass().getName() + " or missing identifier");
    }
}

