/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import com.cryptomorin.xseries.XMaterial;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaterialHelper {
    private static final short MAX_ID = 2267;
    private static final Map<Integer, XMaterial> LEGACY_MATERIALS;

    @NotNull
    public static XMaterial getType(@Nullable Material type) {
        if (type == null) {
            return XMaterial.AIR;
        }
        return XMaterial.matchXMaterial(type);
    }

    @NotNull
    public static XMaterial getType(@Nullable ItemStack item) {
        if (item == null) {
            return XMaterial.AIR;
        }
        return XMaterial.matchXMaterial(item);
    }

    @NotNull
    public static XMaterial getType(@Nullable Location location) {
        if (location == null) {
            return XMaterial.AIR;
        }
        return MaterialHelper.getType(location.getBlock());
    }

    @NotNull
    public static XMaterial getType(@Nullable Block block) {
        if (block == null) {
            return XMaterial.AIR;
        }
        if (XMaterial.getVersion() >= 13) {
            return XMaterial.matchXMaterial(block.getType());
        }
        return MaterialHelper.getType(block.getTypeId(), block.getData());
    }

    @Deprecated
    @NotNull
    public static XMaterial getType(int id, byte data) {
        if (id < 0 || id > 2267 || data < 0) {
            return XMaterial.AIR;
        }
        Material resolved = Material.getMaterial((int)id);
        int resolvedId = resolved == null ? id : resolved.getId();
        XMaterial resolvedMaterial = LEGACY_MATERIALS.get(resolvedId << 8 | data);
        if (resolvedMaterial == null) {
            resolvedMaterial = LEGACY_MATERIALS.get(resolvedId << 8);
            return resolvedMaterial == null ? XMaterial.AIR : resolvedMaterial;
        }
        return resolvedMaterial;
    }

    public static void setType(@NotNull Block block, @NotNull XMaterial type, boolean applyPhysics) {
        if (XMaterial.getVersion() >= 13) {
            block.setType(type.parseMaterial(), applyPhysics);
        } else {
            block.setTypeIdAndData(type.getId(), type.getData(), applyPhysics);
        }
    }

    public static void setType(@NotNull Block block, @NotNull XMaterial type) {
        MaterialHelper.setType(block, type, true);
    }

    public static void setType(@NotNull Location location, @NotNull XMaterial type, boolean applyPhysics) {
        MaterialHelper.setType(location.getBlock(), type, applyPhysics);
    }

    public static void setType(@NotNull Location location, @NotNull XMaterial type) {
        MaterialHelper.setType(location.getBlock(), type, true);
    }

    private static boolean hasType(int id, byte data) {
        XMaterial resolvedMaterial = LEGACY_MATERIALS.get(id << 8 | data);
        return resolvedMaterial != null || LEGACY_MATERIALS.get(id << 8) != null;
    }

    @Generated
    private MaterialHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        int data;
        int id;
        LEGACY_MATERIALS = new HashMap<Integer, XMaterial>();
        for (XMaterial xMaterial : XMaterial.values()) {
            id = xMaterial.getId();
            data = xMaterial.getData();
            if (id == -1) continue;
            int key = id << 8 | data;
            LEGACY_MATERIALS.put(key, xMaterial);
        }
        if (!XMaterial.supports(13)) {
            for (XMaterial xMaterial : Material.values()) {
                id = xMaterial.getId();
                for (data = 0; data < 16; ++data) {
                    if (MaterialHelper.hasType(id, (byte)data)) continue;
                    LEGACY_MATERIALS.put(id << 8 | data, XMaterial.matchXMaterial((Material)xMaterial));
                }
            }
            LEGACY_MATERIALS.put(Material.BED_BLOCK.getId() << 8, XMaterial.RED_BED);
            LEGACY_MATERIALS.put(Material.FLOWER_POT.getId() << 8, XMaterial.FLOWER_POT);
            LEGACY_MATERIALS.put(Material.SKULL.getId() << 8, XMaterial.SKELETON_SKULL);
            LEGACY_MATERIALS.put(Material.SIGN_POST.getId() << 8, XMaterial.OAK_SIGN);
            LEGACY_MATERIALS.put(Material.WALL_SIGN.getId() << 8, XMaterial.OAK_WALL_SIGN);
            LEGACY_MATERIALS.put(Material.WOOD_PLATE.getId() << 8, XMaterial.OAK_PRESSURE_PLATE);
            LEGACY_MATERIALS.put(Material.TRAP_DOOR.getId() << 8, XMaterial.OAK_TRAPDOOR);
            LEGACY_MATERIALS.put(Material.DOUBLE_PLANT.getId() << 8, XMaterial.SUNFLOWER);
            LEGACY_MATERIALS.put(Material.DOUBLE_PLANT.getId() << 8 | 1, XMaterial.LILAC);
            LEGACY_MATERIALS.put(Material.DOUBLE_PLANT.getId() << 8 | 2, XMaterial.TALL_GRASS);
            LEGACY_MATERIALS.put(Material.DOUBLE_PLANT.getId() << 8 | 3, XMaterial.LARGE_FERN);
            LEGACY_MATERIALS.put(Material.DOUBLE_PLANT.getId() << 8 | 4, XMaterial.ROSE_BUSH);
            LEGACY_MATERIALS.put(Material.DOUBLE_PLANT.getId() << 8 | 5, XMaterial.PEONY);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8, XMaterial.SMOOTH_STONE_SLAB);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 1, XMaterial.SANDSTONE_SLAB);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 2, XMaterial.PETRIFIED_OAK_SLAB);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 3, XMaterial.COBBLESTONE_SLAB);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 4, XMaterial.BRICK_SLAB);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 5, XMaterial.STONE_BRICK_SLAB);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 6, XMaterial.NETHER_BRICK_SLAB);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 7, XMaterial.QUARTZ_SLAB);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 8, XMaterial.SMOOTH_STONE);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 9, XMaterial.SMOOTH_SANDSTONE);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 0xA, XMaterial.PETRIFIED_OAK_SLAB);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 0xB, XMaterial.COBBLESTONE_SLAB);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 0xC, XMaterial.BRICK_SLAB);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 0xD, XMaterial.STONE_BRICK_SLAB);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 0xE, XMaterial.NETHER_BRICK_SLAB);
            LEGACY_MATERIALS.put(Material.DOUBLE_STEP.getId() << 8 | 0xF, XMaterial.SMOOTH_QUARTZ);
        }
    }
}

