/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.libs.org.apache.commons.dbcp2.managed;

import co.crystaldev.alpinecore.libs.org.apache.commons.dbcp2.PoolableConnection;
import co.crystaldev.alpinecore.libs.org.apache.commons.dbcp2.managed.TransactionRegistry;
import co.crystaldev.alpinecore.libs.org.apache.commons.pool2.ObjectPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

public class PoolableManagedConnection
extends PoolableConnection {
    private final TransactionRegistry transactionRegistry;

    public PoolableManagedConnection(TransactionRegistry transactionRegistry, Connection conn, ObjectPool<PoolableConnection> pool) {
        this(transactionRegistry, conn, pool, null, true);
    }

    public PoolableManagedConnection(TransactionRegistry transactionRegistry, Connection conn, ObjectPool<PoolableConnection> pool, Collection<String> disconnectSqlCodes, boolean fastFailValidation) {
        this(transactionRegistry, conn, pool, disconnectSqlCodes, null, fastFailValidation);
    }

    public PoolableManagedConnection(TransactionRegistry transactionRegistry, Connection conn, ObjectPool<PoolableConnection> pool, Collection<String> disconnectSqlCodes, Collection<String> disconnectionIgnoreSqlCodes, boolean fastFailValidation) {
        super(conn, pool, null, disconnectSqlCodes, disconnectionIgnoreSqlCodes, fastFailValidation);
        this.transactionRegistry = transactionRegistry;
    }

    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    @Override
    public void reallyClose() throws SQLException {
        try {
            super.reallyClose();
        }
        finally {
            this.transactionRegistry.unregisterConnection(this);
        }
    }
}

