/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui.interaction;

import co.crystaldev.alpinecore.framework.ui.event.ActionResult;
import co.crystaldev.alpinecore.framework.ui.interaction.InteractContext;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class DropContext
extends InteractContext {
    private final ClickType type;
    private final InventoryAction action;
    private final ItemStack item;

    public DropContext(@NotNull ClickType type, @NotNull InventoryAction action, @NotNull ItemStack item, @NotNull ActionResult result) {
        super(result);
        this.type = type;
        this.action = action;
        this.item = item;
    }

    @NotNull
    public ClickType type() {
        return this.type;
    }

    @NotNull
    public InventoryAction action() {
        return this.action;
    }

    public boolean hasItem() {
        return this.item != null && this.item.getType() != Material.AIR && this.item.getAmount() > 0;
    }

    @NotNull
    public ItemStack item() {
        return this.item;
    }

    public int amount() {
        if (this.action == InventoryAction.DROP_ONE_CURSOR) {
            return 1;
        }
        return this.item.getAmount();
    }
}

