/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui;

import co.crystaldev.alpinecore.framework.ui.GuiType;
import lombok.Generated;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public final class SlotPosition {
    private final Inventory inventory;
    private final int slot;

    @NotNull
    public GuiType getType() {
        return GuiType.fromType(this.inventory.getType());
    }

    public int getX() {
        return this.slot % this.getType().getRowLength();
    }

    public int getY() {
        return this.slot / this.getType().getRowLength();
    }

    @NotNull
    public static SlotPosition from(@NotNull Inventory inventory, int slot) {
        return new SlotPosition(inventory, slot);
    }

    @NotNull
    public static SlotPosition from(@NotNull Inventory inventory, int x, int y) {
        GuiType type = GuiType.fromType(inventory.getType());
        return new SlotPosition(inventory, y * type.getRowLength() + x);
    }

    @Generated
    public SlotPosition(Inventory inventory, int slot) {
        this.inventory = inventory;
        this.slot = slot;
    }

    @Generated
    public Inventory getInventory() {
        return this.inventory;
    }

    @Generated
    public int getSlot() {
        return this.slot;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlotPosition)) {
            return false;
        }
        SlotPosition other = (SlotPosition)o;
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        Inventory this$inventory = this.getInventory();
        Inventory other$inventory = other.getInventory();
        return !(this$inventory == null ? other$inventory != null : !this$inventory.equals(other$inventory));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlot();
        Inventory $inventory = this.getInventory();
        result = result * 59 + ($inventory == null ? 43 : $inventory.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SlotPosition(inventory=" + this.getInventory() + ", slot=" + this.getSlot() + ")";
    }
}

