/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.teleport;

import co.crystaldev.alpinecore.util.MessageType;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TeleportContext {
    @NotNull
    private final Player player;
    @NotNull
    private Location destination;
    private int ticksUntilTeleport;
    private final boolean canMove;
    @NotNull
    private MessageType messageType = MessageType.DISABLED;
    @Nullable
    private Component message;
    private boolean cancelled;

    TeleportContext(@NotNull Player player, @NotNull Location destination, int ticksUntilTeleport, boolean canMove) {
        this.player = player;
        this.destination = destination;
        this.ticksUntilTeleport = ticksUntilTeleport;
        this.canMove = canMove;
    }

    @NotNull
    public Player player() {
        return this.player;
    }

    @NotNull
    public Location destination() {
        return this.destination;
    }

    public void destination(@NotNull Location destination) {
        this.destination = destination;
    }

    public int ticksUntilTeleport() {
        return this.ticksUntilTeleport;
    }

    public void setTicksUntilTeleport(int ticksUntilTeleport) {
        this.ticksUntilTeleport = ticksUntilTeleport;
    }

    public long timeUntilTeleport(@NotNull TimeUnit unit) {
        return this.isInstant() ? 0L : unit.convert((long)(this.ticksUntilTeleport + 1) * 50L, TimeUnit.MILLISECONDS);
    }

    public void setTimeUntilTeleport(long time, @NotNull TimeUnit unit) {
        this.setTicksUntilTeleport(Math.toIntExact(unit.toMillis(time) / 50L));
    }

    public boolean isInstant() {
        return this.ticksUntilTeleport <= 0;
    }

    public void setInstant() {
        this.ticksUntilTeleport = -1;
    }

    public boolean canMove() {
        return this.canMove;
    }

    @NotNull
    public MessageType messageType() {
        return this.messageType;
    }

    @Nullable
    public Component message() {
        return this.message;
    }

    public void messageType(@NotNull MessageType messageType) {
        this.messageType = messageType;
    }

    public void message(@Nullable Component message) {
        if (message != null && this.messageType == MessageType.DISABLED) {
            this.messageType = MessageType.CHAT;
        }
        this.message = message;
    }

    public void message(@NotNull MessageType type, @Nullable Component message) {
        this.messageType = type;
        this.message = message;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancelTeleport() {
        this.cancelled = true;
    }

    @Generated
    public String toString() {
        return "TeleportContext(player=" + this.player + ", destination=" + this.destination + ", ticksUntilTeleport=" + this.ticksUntilTeleport + ", canMove=" + this.canMove + ", messageType=" + (Object)((Object)this.messageType) + ", message=" + this.message + ", cancelled=" + this.isCancelled() + ")";
    }
}

