/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.config.AlpinePluginConfig;
import co.crystaldev.alpinecore.util.Components;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Formatting {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    @NotNull
    public static String placeholders(@NotNull MiniMessage miniMessage, @Nullable String text, Object ... placeholders) {
        if (text == null) {
            return "";
        }
        if (placeholders == null || placeholders.length < 2) {
            return text;
        }
        for (int i = 0; i < placeholders.length / 2 * 2; i += 2) {
            String placeholder = (String)placeholders[i];
            Object rawReplacer = placeholders[i + 1];
            text = Formatting.formatPlaceholder(miniMessage, text, rawReplacer, placeholder);
        }
        return text;
    }

    @NotNull
    public static String placeholders(@NotNull AlpinePlugin plugin, @Nullable String text, Object ... placeholders) {
        if (text != null) {
            HashMap<String, String> variables = plugin.getAlpineConfig().variables;
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                text = text.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        return Formatting.placeholders(plugin.getStrictMiniMessage(), text, placeholders);
    }

    @NotNull
    public static String placeholders(@Nullable String text, Object ... placeholders) {
        return Formatting.placeholders(MiniMessage.miniMessage(), text, placeholders);
    }

    @NotNull
    public static String placeholders(@NotNull MiniMessage miniMessage, @Nullable String text, @NotNull Map<String, Object> placeholders) {
        if (text == null) {
            return "";
        }
        if (placeholders.isEmpty()) {
            return text;
        }
        for (Map.Entry<String, Object> entry : placeholders.entrySet()) {
            String placeholder = entry.getKey();
            Object rawReplacer = entry.getValue();
            text = Formatting.formatPlaceholder(miniMessage, text, rawReplacer, placeholder);
        }
        return text;
    }

    @NotNull
    public static String placeholders(@NotNull AlpinePlugin plugin, @Nullable String text, @NotNull Map<String, Object> placeholders) {
        if (text != null) {
            HashMap<String, String> variables = plugin.getAlpineConfig().variables;
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                text = text.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        return Formatting.placeholders(plugin.getStrictMiniMessage(), text, placeholders);
    }

    @NotNull
    public static String placeholders(@Nullable String text, @NotNull Map<String, Object> placeholders) {
        return Formatting.placeholders(MiniMessage.miniMessage(), text, placeholders);
    }

    @Deprecated
    @NotNull
    public static String formatPlaceholders(@NotNull MiniMessage miniMessage, @Nullable String text, Object ... placeholders) {
        return Formatting.placeholders(miniMessage, text, placeholders);
    }

    @Deprecated
    @NotNull
    public static String formatPlaceholders(@NotNull AlpinePlugin plugin, @Nullable String text, Object ... placeholders) {
        return Formatting.placeholders(plugin, text, placeholders);
    }

    @Deprecated
    @NotNull
    public static String formatPlaceholders(@Nullable String text, Object ... placeholders) {
        return Formatting.placeholders(text, placeholders);
    }

    @Deprecated
    @NotNull
    public static String formatPlaceholders(@NotNull MiniMessage miniMessage, @Nullable String text, @NotNull Map<String, Object> placeholders) {
        return Formatting.placeholders(miniMessage, text, placeholders);
    }

    @Deprecated
    @NotNull
    public static String formatPlaceholders(@NotNull AlpinePlugin plugin, @Nullable String text, @NotNull Map<String, Object> placeholders) {
        return Formatting.placeholders(plugin, text, placeholders);
    }

    @Deprecated
    @NotNull
    public static String formatPlaceholders(@Nullable String text, @NotNull Map<String, Object> placeholders) {
        return Formatting.placeholders(text, placeholders);
    }

    @NotNull
    private static String formatPlaceholder(@NotNull MiniMessage miniMessage, @NotNull String text, Object value, String placeholder) {
        String formattedReplacer = value instanceof Float || value instanceof Double ? DECIMAL_FORMAT.format(value) : (value instanceof Boolean ? ((Boolean)value != false ? "True" : "False") : (value instanceof Component ? (String)miniMessage.serialize(((Component)value).append(Components.reset())) : (value instanceof Supplier ? ((Supplier)value).get().toString() : value.toString())));
        text = text.replace("%" + placeholder + "%", formattedReplacer);
        return text;
    }

    @NotNull
    public static Component applyTitlePadding(@NotNull AlpinePlugin plugin, @NotNull Component component) {
        AlpinePluginConfig config = plugin.getAlpineConfig();
        if (!config.titleUsesPadding) {
            return component;
        }
        int paddingLength = Math.max(4, (config.titlePaddingLength - Components.length(component)) / 2);
        String paddingString = Formatting.repeat(config.paddingCharacter, paddingLength);
        Component padding = Components.stylize(config.paddingStyle, Component.text(paddingString));
        return Components.join(padding, component, padding);
    }

    @NotNull
    public static Component title(@NotNull AlpinePlugin plugin, @NotNull Component component) {
        AlpinePluginConfig config = plugin.getAlpineConfig();
        component = config.titleFormat.build(plugin, "content", component);
        return Formatting.applyTitlePadding(plugin, component);
    }

    @NotNull
    public static <T> Component elements(@NotNull AlpinePlugin plugin, @NotNull Collection<T> elements, @NotNull @NotNull Function<@NotNull T, Component> toComponentFn) {
        AlpinePluginConfig config = plugin.getAlpineConfig();
        LinkedList<Component> pageElements = new LinkedList<Component>();
        for (T element : elements) {
            if (element == null) continue;
            pageElements.add(toComponentFn.apply(element));
        }
        if (pageElements.isEmpty()) {
            return config.noPages.build(plugin, new Object[0]);
        }
        return Components.joinNewLines(pageElements);
    }

    @NotNull
    public static <T> Component page(@NotNull AlpinePlugin plugin, @NotNull Component title, @NotNull Collection<T> elements, @NotNull String command, int currentPage, int elementsPerPage, @NotNull @NotNull Function<@NotNull T, Component> toComponentFn) {
        AlpinePluginConfig config = plugin.getAlpineConfig();
        LinkedList<Component> pageElements = new LinkedList<Component>();
        int totalPages = (int)Math.ceil((double)elements.size() / (double)elementsPerPage);
        int humanPage = currentPage--;
        int index = 0;
        for (T element : elements) {
            if (element == null) continue;
            if (pageElements.size() >= elementsPerPage) break;
            if (index >= currentPage * elementsPerPage) {
                pageElements.add(toComponentFn.apply(element));
            }
            ++index;
        }
        if (pageElements.isEmpty()) {
            return config.noPages.build(plugin, new Object[0]);
        }
        Component previous = currentPage == 0 ? config.previousDisabled.build(plugin, new Object[0]) : Components.events(config.previous.build(plugin, new Object[0]), Formatting.placeholders(command, "page", humanPage - 1));
        Component next = currentPage == totalPages - 1 ? config.nextDisabled.build(plugin, new Object[0]) : Components.events(config.next.build(plugin, new Object[0]), Formatting.placeholders(command, "page", humanPage + 1));
        Component center = config.paginatorTitleFormat.build(plugin, "content", title, "page", humanPage, "max_pages", totalPages, "previous", previous, "next", next);
        return Components.joinNewLines(Formatting.applyTitlePadding(plugin, center), Components.joinNewLines(pageElements));
    }

    @NotNull
    public static Component progress(@NotNull AlpinePlugin plugin, double progress) {
        progress = Math.max(0.0, Math.min(1.0, progress));
        AlpinePluginConfig config = plugin.getAlpineConfig();
        int fillLength = (int)((double)config.progressLength * progress);
        Component progressComponent = Components.join(Components.stylize(config.progressIndicatorStyle, Component.text(Formatting.repeat(config.progressIndicatorCharacter, fillLength))), Components.stylize(config.progressRemainingStyle, Component.text(Formatting.repeat(config.progressRemainingCharacter, config.progressLength - fillLength))));
        return config.progressBarFormat.build(plugin, "progress", progressComponent);
    }

    @NotNull
    private static String repeat(@NotNull String string, int count) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Generated
    private Formatting() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

