/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui.event;

import co.crystaldev.alpinecore.framework.ui.UIContext;
import co.crystaldev.alpinecore.framework.ui.event.ActionResult;
import co.crystaldev.alpinecore.framework.ui.event.EventCallback;
import co.crystaldev.alpinecore.framework.ui.event.RegisteredEventCallback;
import co.crystaldev.alpinecore.framework.ui.event.UIEvent;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UIEventBus {
    private final Map<Class<? extends UIEvent>, List<RegisteredEventCallback<?>>> subscribers = new ConcurrentHashMap();

    @NotNull
    public <T extends UIEvent> ActionResult call(@NotNull UIContext context, @NotNull T event) {
        List<RegisteredEventCallback<?>> callbacks = this.subscribers.get(event.getClass());
        if (callbacks != null) {
            for (RegisteredEventCallback<?> callback : callbacks) {
                ActionResult result = callback.callback.invoke(context, event);
                Validate.notNull((Object)((Object)result), (String)"UIEvent result cannot not be null");
                if (result == ActionResult.PASS) continue;
                return result;
            }
        }
        return ActionResult.PASS;
    }

    public <T extends UIEvent> void register(@Nullable Object source, @NotNull Class<T> type, byte priority, @NotNull EventCallback<T> callback) {
        List callbacks = this.subscribers.computeIfAbsent(type, k -> new CopyOnWriteArrayList());
        callbacks.add(new RegisteredEventCallback<T>(source, callback, priority));
        callbacks.sort(Comparator.comparing(v -> v.priority));
    }

    public <T extends UIEvent> void register(@NotNull Class<T> type, byte priority, @NotNull EventCallback<T> callback) {
        this.register(null, type, priority, callback);
    }

    public <T extends UIEvent> void register(@Nullable Object source, @NotNull Class<T> type, @NotNull EventCallback<T> callback) {
        this.register(source, type, (byte)30, callback);
    }

    public <T extends UIEvent> void register(@NotNull Class<T> type, @NotNull EventCallback<T> callback) {
        this.register(type, (byte)30, callback);
    }

    public void unregister(@NotNull Object source) {
        this.subscribers.values().forEach(v -> v.removeIf(callback -> Objects.equals(callback, source)));
        this.subscribers.entrySet().removeIf(v -> ((List)v.getValue()).isEmpty());
    }
}

