/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.integration;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.Activatable;
import co.crystaldev.alpinecore.framework.integration.AlpineIntegrationEngine;
import java.lang.reflect.Constructor;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AlpineIntegration
implements Listener,
Activatable {
    protected final AlpinePlugin plugin;
    @Nullable
    private AlpineIntegrationEngine engine;

    protected AlpineIntegration(@NotNull AlpinePlugin plugin) {
        this.plugin = plugin;
    }

    protected abstract boolean shouldActivate();

    @NotNull
    protected abstract Class<? extends AlpineIntegrationEngine> getEngineClass();

    @Override
    public final void activate(@NotNull AlpinePlugin context) {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        if (this.shouldActivate()) {
            try {
                Constructor<? extends AlpineIntegrationEngine> constructor = this.getEngineClass().getDeclaredConstructor(AlpinePlugin.class);
                constructor.setAccessible(true);
                AlpineIntegrationEngine engine = constructor.newInstance(new Object[]{this.plugin});
                this.plugin.getServer().getPluginManager().registerEvents((Listener)engine, (Plugin)this.plugin);
                this.engine = engine;
                if (!this.getClass().getPackage().getName().startsWith("co.crystaldev.alpinecore")) {
                    this.plugin.log(String.format("&aIntegration activated &d%s", this.getClass().getSimpleName()));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public final void deactivate(@NotNull AlpinePlugin context) {
        HandlerList.unregisterAll((Listener)this);
        HandlerList.unregisterAll((Listener)this.engine);
        this.engine = null;
        this.plugin.log(String.format("&cIntegration deactivated &d%s", this.getClass().getSimpleName()));
    }

    @Override
    public final boolean isActive() {
        return this.engine != null;
    }

    @EventHandler
    private void onPluginEnabled(PluginEnableEvent event) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, this::checkActivation, 1L);
    }

    @EventHandler
    private void onPluginDisabled(PluginDisableEvent event) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, this::checkActivation, 1L);
    }

    protected final void checkActivation() {
        boolean shouldActivate = this.shouldActivate();
        if (shouldActivate && !this.isActive()) {
            this.plugin.addActivatable(this);
        } else if (!shouldActivate && this.isActive()) {
            this.plugin.removeActivatable(this);
        }
    }

    @Nullable
    @Generated
    public AlpineIntegrationEngine getEngine() {
        return this.engine;
    }
}

