/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.cooldown;

import co.crystaldev.alpinecore.framework.cooldown.Warmup;
import co.crystaldev.alpinecore.util.MessageType;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Cooldown<T> {
    @NotNull
    private final T entity;
    private int remainingTicks;
    private final boolean canMove;
    @Nullable
    private final Location origin;
    @NotNull
    private MessageType messageType = MessageType.DISABLED;
    @Nullable
    private Component message;
    private boolean cancelled;

    Cooldown(@NotNull T entity, int remainingTicks, boolean canMove, @Nullable Location origin) {
        this.entity = entity;
        this.remainingTicks = remainingTicks;
        this.canMove = canMove;
        this.origin = origin;
    }

    @NotNull
    public T getEntity() {
        return this.entity;
    }

    public boolean isActive() {
        return this.remainingTicks > 0;
    }

    public boolean isWarmup() {
        return this instanceof Warmup;
    }

    public int remainingTicks() {
        return this.remainingTicks;
    }

    public void setRemainingTicks(int remainingTicks) {
        this.remainingTicks = remainingTicks;
    }

    public long remainingTime(@NotNull TimeUnit unit) {
        return this.isInstant() ? 0L : unit.convert((long)(this.remainingTicks + 1) * 50L, TimeUnit.MILLISECONDS);
    }

    public void setRemainingTime(long time, @NotNull TimeUnit unit) {
        this.setRemainingTicks(Math.toIntExact(unit.toMillis(time) / 50L));
    }

    public boolean isInstant() {
        return this.remainingTicks <= 0;
    }

    public void setInstant() {
        this.setRemainingTicks(-1);
    }

    public boolean canMove() {
        return this.canMove;
    }

    @NotNull
    public MessageType messageType() {
        return this.messageType;
    }

    @Nullable
    public Component message() {
        return this.message;
    }

    public void messageType(@NotNull MessageType messageType) {
        this.messageType = messageType;
    }

    public void message(@Nullable Component message) {
        if (message != null && this.messageType == MessageType.DISABLED) {
            this.messageType = MessageType.CHAT;
        }
        this.message = message;
    }

    public void message(@NotNull MessageType type, @Nullable Component message) {
        this.messageType = type;
        this.message = message;
    }

    public void clearMessage() {
        this.messageType = MessageType.DISABLED;
        this.message = null;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
    }

    int tick() {
        int n;
        if (this.remainingTicks > 0) {
            int n2 = this.remainingTicks;
            n = n2;
            this.remainingTicks = n2 - 1;
        } else {
            n = 0;
        }
        return n;
    }

    void complete() {
    }

    @Generated
    public String toString() {
        return "Cooldown(entity=" + this.getEntity() + ", remainingTicks=" + this.remainingTicks + ", canMove=" + this.canMove + ", origin=" + this.getOrigin() + ", messageType=" + (Object)((Object)this.messageType) + ", message=" + this.message + ", cancelled=" + this.isCancelled() + ")";
    }

    @Nullable
    @Generated
    Location getOrigin() {
        return this.origin;
    }
}

