/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.config;

import co.crystaldev.alpinecore.AlpinePlugin;
import de.exlll.configlib.YamlConfigurationProperties;
import de.exlll.configlib.YamlConfigurations;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigLoader<T> {
    private final Path directory;
    private final Class<T> configClass;
    private final Map<String, T> configRegistry = new HashMap<String, T>();

    private ConfigLoader(@NotNull AlpinePlugin plugin, @NotNull Class<T> configClass, @NotNull Path directory, @NotNull Map<String, Supplier<T>> defaultConfigs) {
        this.directory = directory;
        this.configClass = configClass;
        boolean createdDirectory = false;
        if (!Files.isDirectory(this.directory, new LinkOption[0])) {
            try {
                Files.createDirectories(this.directory, new FileAttribute[0]);
                createdDirectory = true;
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to generate dynamic configuration root directory", ex);
            }
        }
        YamlConfigurationProperties properties = plugin.getConfigManager().properties;
        try (Stream<Path> stream = Files.list(this.directory);){
            stream.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".yml")).forEach(file -> {
                T config = YamlConfigurations.load(file, this.configClass, properties);
                String fileName = file.getFileName().toString();
                String configName = fileName.substring(0, fileName.lastIndexOf("."));
                this.configRegistry.put(configName, config);
            });
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load dynamic configuration", ex);
        }
        if (createdDirectory) {
            defaultConfigs.forEach((name, supplier) -> {
                Object config = supplier.get();
                this.configRegistry.put((String)name, config);
                String fileName = name + ".yml";
                Path configPath = this.directory.resolve(fileName);
                YamlConfigurations.save(configPath, this.configClass, config, properties);
            });
        }
    }

    @NotNull
    public Set<String> getConfigKeys() {
        return this.configRegistry.keySet();
    }

    @NotNull
    public Collection<T> getConfigs() {
        return this.configRegistry.values();
    }

    public boolean isLoaded(@NotNull String name) {
        return this.configRegistry.containsKey(name);
    }

    @Nullable
    public T getConfig(@NotNull String name) {
        return this.configRegistry.get(name);
    }

    public boolean isEmpty() {
        return this.configRegistry.isEmpty();
    }

    @NotNull
    public static <T> Builder<T> builder(@NotNull AlpinePlugin plugin, @NotNull Class<T> configClass, @NotNull String directory) {
        return new Builder(plugin, configClass, directory);
    }

    @Generated
    public Path getDirectory() {
        return this.directory;
    }

    public static final class Builder<T> {
        private final AlpinePlugin plugin;
        private final Class<T> configClass;
        private final Path rootDirectory;
        private final Map<String, Supplier<T>> defaultConfigs = new HashMap<String, Supplier<T>>();

        private Builder(@NotNull AlpinePlugin plugin, @NotNull Class<T> configClass, @NotNull String rootDirectory) {
            this.plugin = plugin;
            this.configClass = configClass;
            this.rootDirectory = plugin.getDataFolder().toPath().resolve(rootDirectory);
        }

        @NotNull
        public Builder<T> addConfiguration(@NotNull String name, @NotNull Supplier<T> configSupplier) {
            Validate.notNull((Object)name, (String)"name cannot be null");
            Validate.notNull(configSupplier, (String)"configSupplier cannot be null");
            this.defaultConfigs.put(name, configSupplier);
            return this;
        }

        @NotNull
        public Builder<T> addConfiguration(@NotNull String name, @NotNull T config) {
            Validate.notNull((Object)name, (String)"name cannot be null");
            Validate.notNull(config, (String)"config cannot be null");
            this.defaultConfigs.put(name, () -> config);
            return this;
        }

        @NotNull
        public ConfigLoader<T> build() {
            return new ConfigLoader(this.plugin, this.configClass, this.rootDirectory, this.defaultConfigs);
        }
    }
}

