/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import co.crystaldev.alpinecore.Reference;
import co.crystaldev.alpinecore.util.Components;
import co.crystaldev.alpinecore.util.MessageType;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Messaging {
    public static void send(@NotNull CommandSender sender, @NotNull MessageType messageType, @Nullable Component component) {
        if (component == null) {
            return;
        }
        switch (messageType) {
            case CHAT: {
                Messaging.send(sender, component);
                break;
            }
            case ACTION_BAR: {
                Messaging.actionBar(sender, component);
            }
        }
    }

    public static void send(@NotNull CommandSender sender, @NotNull MessageType messageType, Component ... components) {
        if (components == null || components.length == 0) {
            return;
        }
        switch (messageType) {
            case CHAT: {
                Messaging.send(sender, components);
                break;
            }
            case ACTION_BAR: {
                Messaging.actionBar(sender, components);
            }
        }
    }

    public static void send(@NotNull Collection<CommandSender> senders, @NotNull MessageType messageType, @NotNull @NotNull Function<@NotNull CommandSender, @Nullable Component> componentFunction) {
        if (messageType == MessageType.DISABLED) {
            return;
        }
        for (CommandSender sender : senders) {
            Component component = componentFunction.apply(sender);
            if (component == null) continue;
            Messaging.send(sender, messageType, component);
        }
    }

    public static void send(@NotNull CommandSender sender, @Nullable Component component) {
        if (component == null) {
            return;
        }
        if (sender instanceof Audience) {
            ((Audience)sender).sendMessage(component);
        } else {
            Messaging.wrap(sender).sendMessage(component);
        }
    }

    public static void send(@NotNull CommandSender sender, Component ... components) {
        Messaging.send(sender, Components.joinNewLines(components));
    }

    public static void send(@NotNull Collection<CommandSender> senders, @NotNull @NotNull Function<@NotNull CommandSender, @Nullable Component> componentFunction) {
        for (CommandSender sender : senders) {
            Component component = componentFunction.apply(sender);
            if (component == null) continue;
            Messaging.wrap(sender).sendMessage(component);
        }
    }

    public static void attemptSend(@NotNull OfflinePlayer sender, @Nullable Component component) {
        if (component == null || !sender.isOnline()) {
            return;
        }
        if (sender instanceof Audience) {
            ((Audience)sender).sendMessage(component);
        } else if (sender instanceof CommandSender) {
            Messaging.wrap((CommandSender)sender).sendMessage(component);
        }
    }

    public static void attemptSend(@NotNull OfflinePlayer sender, Component ... components) {
        Messaging.attemptSend(sender, Components.joinNewLines(components));
    }

    public static void attemptSend(@NotNull Collection<OfflinePlayer> players, @NotNull @NotNull Function<@NotNull Player, @Nullable Component> componentFunction) {
        for (OfflinePlayer offlinePlayer : players) {
            Player player;
            Component component;
            if (!offlinePlayer.isOnline() || (component = componentFunction.apply(player = offlinePlayer.getPlayer())) == null) continue;
            Messaging.wrap((CommandSender)player).sendMessage(component);
        }
    }

    public static void broadcast(@Nullable Component component) {
        if (component == null) {
            return;
        }
        Messaging.wrap((CommandSender)Bukkit.getServer().getConsoleSender()).sendMessage(component);
        Bukkit.getOnlinePlayers().forEach(player -> Messaging.send((CommandSender)player, component));
    }

    public static void broadcast(Component ... components) {
        Messaging.broadcast(Components.joinNewLines(components));
    }

    public static void broadcast(@NotNull Component component, @NotNull Predicate<Player> playerPredicate) {
        Messaging.wrap((CommandSender)Bukkit.getServer().getConsoleSender()).sendMessage(component);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!playerPredicate.test(player)) continue;
            Messaging.send((CommandSender)player, component);
        }
    }

    public static void broadcast(@NotNull Collection<CommandSender> senders, @NotNull Component component) {
        for (CommandSender sender : senders) {
            Messaging.wrap(sender).sendMessage(component);
        }
    }

    public static void title(@NotNull CommandSender sender, @NotNull Component title, @NotNull Component subtitle) {
        Messaging.wrap(sender).showTitle(Title.title(title, subtitle));
    }

    public static void actionBar(@NotNull CommandSender sender, @NotNull Component component) {
        Messaging.wrap(sender).sendActionBar(component);
    }

    public static void actionBar(@NotNull CommandSender sender, Component ... components) {
        Messaging.wrap(sender).sendActionBar(Components.joinNewLines(components));
    }

    public static void actionBar(@NotNull Collection<CommandSender> senders, @NotNull @NotNull Function<@NotNull CommandSender, @Nullable Component> componentFunction) {
        for (CommandSender sender : senders) {
            Component component = componentFunction.apply(sender);
            if (component == null) continue;
            Messaging.wrap(sender).sendActionBar(component);
        }
    }

    @NotNull
    public static Audience wrap(@NotNull CommandSender sender) {
        if (sender instanceof Audience) {
            return (Audience)sender;
        }
        return sender instanceof Player ? Reference.AUDIENCES.player((Player)sender) : Reference.AUDIENCES.sender(sender);
    }

    @Generated
    private Messaging() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

