/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.config.object.ConfigMessage;
import co.crystaldev.alpinecore.util.Messaging;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessageDispatcher {
    private final AlpinePlugin plugin;
    private final long rateLimitDuration;
    private final Cache<Long, Long> rateLimited;

    private MessageDispatcher(@NotNull AlpinePlugin plugin, long rateLimitDuration) {
        this.plugin = plugin;
        this.rateLimitDuration = rateLimitDuration;
        this.rateLimited = this.rateLimitDuration > 0L ? CacheBuilder.newBuilder().expireAfterWrite(this.rateLimitDuration, TimeUnit.MILLISECONDS).build() : null;
    }

    public void send(@NotNull CommandSender sender, @NotNull Component component) {
        if (this.rateLimited != null) {
            try {
                long hash = Objects.hash(sender.getName().hashCode(), component.hashCode());
                long now = System.currentTimeMillis();
                Long expireTime = (Long)this.rateLimited.getIfPresent((Object)hash);
                if (expireTime != null && now < expireTime) {
                    return;
                }
                this.rateLimited.put((Object)hash, (Object)(now + this.rateLimitDuration));
            }
            catch (Exception ex) {
                this.plugin.log("Unable to deliver rate-limited message to " + sender.getName(), ex);
            }
        }
        Messaging.send(sender, component);
    }

    public void send(@NotNull CommandSender sender, @Nullable CommandSender relational, @NotNull ConfigMessage message, @NotNull Map<String, Object> placeholders) {
        if (sender instanceof OfflinePlayer) {
            OfflinePlayer relationalPlayer = relational instanceof OfflinePlayer ? (OfflinePlayer)relational : null;
            this.send(sender, message.build(this.plugin, (OfflinePlayer)sender, relationalPlayer, new Object[]{placeholders}));
        } else {
            this.send(sender, message.build(this.plugin, placeholders));
        }
    }

    public void send(@NotNull CommandSender sender, @Nullable CommandSender relational, @NotNull ConfigMessage message, Object ... placeholders) {
        if (sender instanceof OfflinePlayer) {
            OfflinePlayer relationalPlayer = relational instanceof OfflinePlayer ? (OfflinePlayer)relational : null;
            this.send(sender, message.build(this.plugin, (OfflinePlayer)sender, relationalPlayer, placeholders));
        } else {
            this.send(sender, message.build(this.plugin, placeholders));
        }
    }

    public void send(@NotNull CommandSender sender, @NotNull ConfigMessage message, @NotNull Map<String, Object> placeholders) {
        this.send(sender, message.build(this.plugin, placeholders));
    }

    public void send(@NotNull CommandSender sender, @NotNull ConfigMessage message, Object ... placeholders) {
        this.send(sender, message.build(this.plugin, placeholders));
    }

    @NotNull
    public static MessageDispatcher create(@NotNull AlpinePlugin plugin) {
        return new MessageDispatcher(plugin, -1L);
    }

    @NotNull
    public static MessageDispatcher create(@NotNull AlpinePlugin plugin, long rateLimitDuration) {
        return new MessageDispatcher(plugin, rateLimitDuration);
    }

    @NotNull
    public static MessageDispatcher create(@NotNull AlpinePlugin plugin, long rateLimitDuration, @NotNull TimeUnit unit) {
        return new MessageDispatcher(plugin, unit.toMillis(rateLimitDuration));
    }
}

