/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui.type;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.config.object.item.DefinedConfigItem;
import co.crystaldev.alpinecore.framework.ui.handler.UIHandler;
import co.crystaldev.alpinecore.framework.ui.type.InventoryUI;
import co.crystaldev.alpinecore.util.CollectionUtils;
import com.google.common.annotations.Beta;
import de.exlll.configlib.Configuration;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Configuration
@Beta
public final class ConfigInventoryUI {
    private String name;
    private String[] slots;
    private LinkedHashMap<String, String> dictionary;
    private LinkedHashMap<String, DefinedConfigItem> items;

    public int countSymbol(@NotNull String key) {
        String symbol = null;
        for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
            if (!entry.getValue().equals(key)) continue;
            symbol = entry.getKey();
            break;
        }
        if (symbol == null) {
            return 0;
        }
        int amount = 0;
        for (String slot : this.slots) {
            for (char ch : slot.toCharArray()) {
                if (ch != symbol.charAt(0)) continue;
                ++amount;
            }
        }
        return amount;
    }

    @NotNull
    public InventoryUI build(@NotNull AlpinePlugin plugin, @NotNull UIHandler handler) {
        return new InventoryUI(this, plugin, handler);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public ConfigInventoryUI(String name, String[] slots, LinkedHashMap<String, String> dictionary, LinkedHashMap<String, DefinedConfigItem> items) {
        this.name = name;
        this.slots = slots;
        this.dictionary = dictionary;
        this.items = items;
    }

    @Generated
    public ConfigInventoryUI() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String[] getSlots() {
        return this.slots;
    }

    @Generated
    public LinkedHashMap<String, String> getDictionary() {
        return this.dictionary;
    }

    @Generated
    public LinkedHashMap<String, DefinedConfigItem> getItems() {
        return this.items;
    }

    public static final class Builder {
        private String name;
        private String[] slots;
        private LinkedHashMap<String, String> dictionary;
        private final LinkedHashMap<String, DefinedConfigItem> items = new LinkedHashMap();

        @NotNull
        public Builder name(@NotNull String name) {
            Validate.notNull((Object)name, (String)"name cannot be null");
            this.name = name;
            return this;
        }

        @NotNull
        public Builder slots(String ... slots) {
            Validate.notNull((Object)slots, (String)"slots cannot be null");
            this.slots = slots;
            return this;
        }

        @NotNull
        public Builder dictionary(String ... dictionary) {
            Validate.notNull((Object)dictionary, (String)"dictionary cannot be null");
            Validate.isTrue((dictionary.length >= 2 ? 1 : 0) != 0, (String)"dictionary must have at least 2 entries");
            this.dictionary = CollectionUtils.linkedMapFromArray(dictionary);
            return this;
        }

        @NotNull
        public Builder dictionary(@NotNull Map<String, String> dictionary) {
            Validate.notNull(dictionary, (String)"dictionary cannot be null");
            this.dictionary = new LinkedHashMap<String, String>(dictionary);
            return this;
        }

        @NotNull
        public Builder item(@NotNull String key, @NotNull DefinedConfigItem item) {
            Validate.notNull((Object)key, (String)"key cannot be null");
            Validate.notNull((Object)item, (String)"item cannot be null");
            this.items.put(key, item);
            return this;
        }

        @NotNull
        public Builder item(@NotNull String key, @NotNull ItemStack item) {
            Validate.notNull((Object)key, (String)"key cannot be null");
            Validate.notNull((Object)item, (String)"item cannot be null");
            return this.item(key, DefinedConfigItem.fromItem(item));
        }

        @NotNull
        public ConfigInventoryUI build() {
            Validate.notNull((Object)this.name, (String)"name cannot be null");
            Validate.notNull((Object)this.slots, (String)"slots cannot be null");
            Validate.notNull(this.dictionary, (String)"dictionary cannot be null");
            Validate.notNull(this.items, (String)"items cannot be null");
            return new ConfigInventoryUI(this.name, this.slots, this.dictionary, this.items);
        }
    }
}

