/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui.handler;

import co.crystaldev.alpinecore.framework.config.object.item.DefinedConfigItem;
import co.crystaldev.alpinecore.framework.ui.SlotPosition;
import co.crystaldev.alpinecore.framework.ui.UIContext;
import co.crystaldev.alpinecore.framework.ui.element.Element;
import co.crystaldev.alpinecore.framework.ui.element.type.GenericElement;
import co.crystaldev.alpinecore.framework.ui.event.UIEventSubscriber;
import co.crystaldev.alpinecore.framework.ui.interaction.DropContext;
import co.crystaldev.alpinecore.framework.ui.type.ConfigInventoryUI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UIHandler
implements UIEventSubscriber {
    public void init(@NotNull UIContext context) {
    }

    public void tick(@NotNull UIContext context) {
    }

    public void beforeRefresh(@NotNull UIContext context) {
    }

    public void afterRefresh(@NotNull UIContext context) {
    }

    public void closed(@NotNull UIContext context) {
    }

    public void dropped(@NotNull UIContext context, @NotNull DropContext drop) {
    }

    public boolean openParentOnClose(@NotNull UIContext context) {
        return false;
    }

    @NotNull
    public Map<String, Object> getTitlePlaceholders(@NotNull UIContext context) {
        return Collections.emptyMap();
    }

    public void fill(@NotNull UIContext context) {
        ConfigInventoryUI properties = context.ui().getProperties();
        LinkedHashMap<String, String> dictionary = properties.getDictionary();
        String[] slots = properties.getSlots();
        context.clearElements();
        for (int y = 0; y < slots.length; ++y) {
            String row = slots[y];
            for (int x = 0; x < row.length(); ++x) {
                String key;
                char symbol = row.charAt(x);
                if (symbol == ' ' || (key = (String)dictionary.get(Character.toString(symbol))) == null) continue;
                Element element = this.populateElement(context, key);
                element.setPosition(SlotPosition.from(context.inventory(), x, y));
                context.addElement(element);
            }
        }
    }

    @Nullable
    public abstract Element createElement(@NotNull UIContext var1, @NotNull String var2, @Nullable DefinedConfigItem var3);

    @NotNull
    public final Element populateElement(@NotNull UIContext context, @NotNull String key) {
        ConfigInventoryUI properties = context.ui().getProperties();
        LinkedHashMap<String, DefinedConfigItem> dictionary = properties.getItems();
        Element entry = this.createElement(context, key, (DefinedConfigItem)dictionary.get(key));
        if (entry != null) {
            return entry;
        }
        if (dictionary.containsKey(key)) {
            DefinedConfigItem configItem = (DefinedConfigItem)dictionary.get(key);
            GenericElement element = new GenericElement(context, configItem.build(context.manager().getPlugin(), new Object[0]));
            element.putAttributes(Optional.ofNullable(configItem.getAttributes()).orElse(Collections.emptyMap()));
            return element;
        }
        ItemStack itemStack = new ItemStack(Material.BARRIER, 1);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ChatColor.RED + "Undefined Element: " + key);
        itemStack.setItemMeta(itemMeta);
        return new GenericElement(context, itemStack);
    }
}

