/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.config.object;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.integration.PlaceholderIntegration;
import co.crystaldev.alpinecore.util.Formatting;
import de.exlll.configlib.Configuration;
import de.exlll.configlib.Serializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Configuration
public class ConfigMessage {
    protected List<String> message;

    protected ConfigMessage(@NotNull List<String> message) {
        LinkedList<String> processedMessage = new LinkedList<String>();
        for (String s : message) {
            processedMessage.addAll(Arrays.asList(s.split("(<br>|\n|\r)")));
        }
        this.message = processedMessage;
    }

    protected ConfigMessage(@NotNull String message) {
        this(Arrays.asList(message.split("(<br>|\n|\r)")));
    }

    @NotNull
    public static ConfigMessage of(@NotNull String component) {
        return new ConfigMessage(Collections.singletonList(component));
    }

    @NotNull
    public static ConfigMessage of(String ... components) {
        return new ConfigMessage(Arrays.asList(components));
    }

    @NotNull
    public Component build(@NotNull AlpinePlugin plugin, Object ... placeholders) {
        String formatted = Formatting.placeholders(plugin, String.join((CharSequence)"\n", this.message), placeholders);
        return plugin.getMiniMessage().deserialize(formatted);
    }

    @NotNull
    public Component build(@NotNull AlpinePlugin plugin, @NotNull OfflinePlayer targetPlayer, Object ... placeholders) {
        String formatted = Formatting.placeholders(plugin, String.join((CharSequence)"\n", this.message), placeholders);
        PlaceholderIntegration integration = plugin.getActivatable(PlaceholderIntegration.class);
        if (integration != null) {
            formatted = integration.replace(targetPlayer, true, formatted);
        }
        return plugin.getMiniMessage().deserialize(formatted);
    }

    @NotNull
    public Component build(@NotNull AlpinePlugin plugin, @NotNull Map<String, Object> placeholders) {
        String formatted = Formatting.placeholders(plugin, String.join((CharSequence)"\n", this.message), placeholders);
        return plugin.getMiniMessage().deserialize(formatted);
    }

    @NotNull
    public Component build(@NotNull AlpinePlugin plugin, @NotNull OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        String formatted = Formatting.placeholders(plugin, String.join((CharSequence)"\n", this.message), placeholders);
        PlaceholderIntegration integration = plugin.getActivatable(PlaceholderIntegration.class);
        if (integration != null) {
            formatted = integration.replace(targetPlayer, otherPlayer, true, formatted);
        }
        return plugin.getMiniMessage().deserialize(formatted);
    }

    @NotNull
    public String buildString(@NotNull AlpinePlugin plugin, Object ... placeholders) {
        return Formatting.placeholders(plugin, String.join((CharSequence)"\n", this.message), placeholders);
    }

    @NotNull
    public String buildString(@NotNull AlpinePlugin plugin, @NotNull OfflinePlayer targetPlayer, Object ... placeholders) {
        String formatted = Formatting.placeholders(plugin, String.join((CharSequence)"\n", this.message), placeholders);
        PlaceholderIntegration integration = plugin.getActivatable(PlaceholderIntegration.class);
        if (integration == null) {
            return formatted;
        }
        return integration.replace(targetPlayer, true, formatted);
    }

    @NotNull
    public String buildString(@NotNull AlpinePlugin plugin, @NotNull Map<String, Object> placeholders) {
        return Formatting.placeholders(plugin, String.join((CharSequence)"\n", this.message), placeholders);
    }

    @NotNull
    public String buildString(@NotNull AlpinePlugin plugin, @NotNull OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        String formatted = Formatting.placeholders(plugin, String.join((CharSequence)"\n", this.message), placeholders);
        PlaceholderIntegration integration = plugin.getActivatable(PlaceholderIntegration.class);
        if (integration == null) {
            return formatted;
        }
        return integration.replace(targetPlayer, otherPlayer, true, formatted);
    }

    @Generated
    public ConfigMessage() {
    }

    public static final class Adapter
    implements Serializer<ConfigMessage, Object> {
        @Override
        public Object serialize(ConfigMessage element) {
            return String.join((CharSequence)"\n", element.message);
        }

        @Override
        public ConfigMessage deserialize(Object element) {
            if (element instanceof Map) {
                Object value = ((Map)element).get("message");
                LinkedList<String> message = value instanceof Collection ? new LinkedList((Collection)value) : Collections.singletonList(value.toString());
                return new ConfigMessage(message);
            }
            if (element instanceof List) {
                return new ConfigMessage(((List)element).stream().map(Object::toString).collect(Collectors.toList()));
            }
            if (element instanceof String) {
                return new ConfigMessage((String)element);
            }
            return new ConfigMessage(element.toString());
        }
    }
}

