/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.reflect;

import dev.rollczi.litecommands.reflect.ReflectIndex;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IterableSuperClassResolver
implements Iterable<Class<?>> {
    private final Class<?> baseType;

    public IterableSuperClassResolver(Class<?> baseType) {
        this.baseType = baseType;
    }

    @Override
    @NotNull
    public Iterator<Class<?>> iterator() {
        return new TypeIterator();
    }

    private class TypeIterator
    implements Iterator<Class<?>> {
        private Class<?> next;
        private Class<?> lastSuperclass;
        private final Queue<Class<?>> interfaces = new LinkedList();
        private final Set<Class<?>> visitedInterfaces = new HashSet();

        private TypeIterator() {
            this.next = IterableSuperClassResolver.this.baseType;
            this.lastSuperclass = IterableSuperClassResolver.this.baseType;
            this.interfaces.addAll(ReflectIndex.getInterfaces(IterableSuperClassResolver.this.baseType));
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Class<?> next() {
            Class<?> nextToReturn = this.next;
            this.next = null;
            if (nextToReturn == null) {
                return null;
            }
            while (!this.interfaces.isEmpty()) {
                Class<?> nextInterface = this.interfaces.poll();
                if (this.visitedInterfaces.contains(nextInterface)) continue;
                this.visitedInterfaces.add(nextInterface);
                this.interfaces.addAll(ReflectIndex.getInterfaces(nextInterface));
                this.next = nextInterface;
                return nextToReturn;
            }
            Class<?> superclass = this.lastSuperclass.getSuperclass();
            if (superclass != null) {
                this.next = superclass;
                this.lastSuperclass = superclass;
                this.interfaces.addAll(ReflectIndex.getInterfaces(superclass));
                return nextToReturn;
            }
            if (this.next == null && nextToReturn != Object.class) {
                this.next = Object.class;
            }
            return nextToReturn;
        }
    }
}

