/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import com.cryptomorin.xseries.base.XModule;
import de.exlll.configlib.ConfigurationException;
import de.exlll.configlib.Serializer;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.commons.lang.Validate;

public final class XModuleSerializer<XForm extends XModule<XForm, ?>>
implements Serializer<XModule<XForm, ?>, String> {
    private final Class<? extends XModule<XForm, ?>> cls;

    public XModuleSerializer(Class<? extends XModule<XForm, ?>> cls) {
        Validate.notNull(cls, (String)"XModule class");
        this.cls = cls;
    }

    @Override
    public String serialize(XModule<XForm, ?> element) {
        return element.name();
    }

    @Override
    public XModule<XForm, ?> deserialize(String element) {
        try {
            Method method = this.cls.getDeclaredMethod("of", String.class);
            Optional opt = (Optional)method.invoke(null, element);
            return (XModule)opt.orElseThrow(() -> {
                String msg = this.createExceptionMessage(element);
                return new RuntimeException(msg);
            });
        }
        catch (ReflectiveOperationException ex) {
            throw new ConfigurationException("Encountered a reflection-based exception during deserialization", ex);
        }
    }

    private String createExceptionMessage(String element) {
        return "XModule class " + this.cls.getSimpleName() + " does not contain value '" + element + "'.";
    }

    public Class<? extends XModule<XForm, ?>> getModuleCls() {
        return this.cls;
    }
}

