/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.command.builder;

import dev.rollczi.litecommands.command.builder.CommandBuilder;
import dev.rollczi.litecommands.command.builder.CommandBuilderImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

abstract class CommandBuilderChildrenBase<SENDER>
implements CommandBuilder<SENDER> {
    protected final Map<String, CommandBuilder<SENDER>> children = new HashMap<String, CommandBuilder<SENDER>>();

    CommandBuilderChildrenBase() {
    }

    @Override
    @NotNull
    public CommandBuilder<SENDER> editChild(String name, UnaryOperator<CommandBuilder<SENDER>> operator) {
        Optional<CommandBuilder<SENDER>> builderOptional = this.getChild(name);
        if (!builderOptional.isPresent()) {
            throw new IllegalArgumentException("Child " + name + " not found");
        }
        CommandBuilder edited = (CommandBuilder)operator.apply(builderOptional.get());
        this.children.put(name, edited);
        return this;
    }

    @Override
    @NotNull
    public CommandBuilder<SENDER> appendChild(String name, UnaryOperator<CommandBuilder<SENDER>> operator) {
        CommandBuilder child = new CommandBuilderImpl().name(name);
        CommandBuilder edited = (CommandBuilder)operator.apply(child);
        return this.appendChild(edited);
    }

    @Override
    @NotNull
    public CommandBuilder<SENDER> appendChild(CommandBuilder<SENDER> builder) {
        Optional<CommandBuilder<SENDER>> optionalDuplicate = this.getChild(builder.name());
        if (optionalDuplicate.isPresent()) {
            CommandBuilder<SENDER> duplicate = optionalDuplicate.get();
            duplicate.meagre(builder);
            return this;
        }
        this.children.put(builder.name(), builder);
        return this;
    }

    @Override
    public Collection<CommandBuilder<SENDER>> children() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    @Override
    public Optional<CommandBuilder<SENDER>> getChild(String test) {
        CommandBuilder<SENDER> context = this.children.get(test);
        if (context != null) {
            return Optional.of(context);
        }
        for (CommandBuilder<SENDER> child : this.children.values()) {
            if (!child.isNameOrAlias(test)) continue;
            return Optional.of(child);
        }
        return Optional.empty();
    }
}

