/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.teleport;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.teleport.TeleportCallbacks;
import co.crystaldev.alpinecore.framework.teleport.TeleportContext;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class TeleportTask {
    private final Player player;
    private final Location origin;
    private final Location destination;
    private final TeleportCallbacks callbacks;
    private int ticksToTeleport;
    private double movementThreshold;

    int tick() {
        int n;
        if (this.ticksToTeleport <= 0) {
            n = this.ticksToTeleport;
        } else {
            int n2 = this.ticksToTeleport;
            n = n2;
            this.ticksToTeleport = n2 - 1;
        }
        return n;
    }

    boolean canMove() {
        return this.ticksToTeleport <= 0 || this.movementThreshold < 0.0;
    }

    void apply(@NotNull TeleportContext context) {
        this.ticksToTeleport = context.ticksUntilTeleport();
    }

    @NotNull
    TeleportContext createContext(boolean instant) {
        if (instant) {
            return new TeleportContext(this.player, this.destination, -1, this.canMove());
        }
        return new TeleportContext(this.player, this.destination, this.ticksToTeleport, this.canMove());
    }

    @NotNull
    public static Builder builder(@NotNull Player player, @NotNull Location destination) {
        return new Builder(player, destination);
    }

    @Generated
    private TeleportTask(Player player, Location origin, Location destination, TeleportCallbacks callbacks, int ticksToTeleport, double movementThreshold) {
        this.player = player;
        this.origin = origin;
        this.destination = destination;
        this.callbacks = callbacks;
        this.ticksToTeleport = ticksToTeleport;
        this.movementThreshold = movementThreshold;
    }

    @Generated
    Player getPlayer() {
        return this.player;
    }

    @Generated
    Location getOrigin() {
        return this.origin;
    }

    @Generated
    Location getDestination() {
        return this.destination;
    }

    @Generated
    TeleportCallbacks getCallbacks() {
        return this.callbacks;
    }

    @Generated
    int getTicksToTeleport() {
        return this.ticksToTeleport;
    }

    @Generated
    double getMovementThreshold() {
        return this.movementThreshold;
    }

    public static final class Builder {
        private final Player player;
        private final Location destination;
        private final TeleportCallbacks callbacks = new TeleportCallbacks();
        private int delayTicks;
        private double movementThreshold = 0.1;

        @NotNull
        public Builder delay(int ticks) {
            this.delayTicks = ticks;
            return this;
        }

        @NotNull
        public Builder delay(int time, @NotNull TimeUnit unit) {
            this.delayTicks = Math.toIntExact(unit.toMillis(time) / 50L);
            return this;
        }

        @NotNull
        public Builder instant() {
            this.delayTicks = -1;
            return this;
        }

        @NotNull
        public Builder instant(boolean instant) {
            return instant ? this.instant() : this;
        }

        @NotNull
        public Builder movementThreshold(double threshold) {
            this.movementThreshold = threshold;
            return this;
        }

        @NotNull
        public Builder allowMovement() {
            this.movementThreshold = -1.0;
            return this;
        }

        @NotNull
        public Builder resetPitchAndYaw() {
            this.destination.setPitch(0.0f);
            this.destination.setYaw(0.0f);
            return this;
        }

        @NotNull
        public Builder onInit(@NotNull Consumer<TeleportContext> contextConsumer) {
            Validate.notNull(contextConsumer, (String)"contextConsumer cannot be null");
            this.callbacks.setOnInit(contextConsumer);
            return this;
        }

        @NotNull
        public Builder onApply(@NotNull Consumer<TeleportContext> contextConsumer) {
            Validate.notNull(contextConsumer, (String)"contextConsumer cannot be null");
            this.callbacks.setOnApply(contextConsumer);
            return this;
        }

        @NotNull
        public Builder onDamage(@NotNull Consumer<TeleportContext> contextConsumer) {
            Validate.notNull(contextConsumer, (String)"contextConsumer cannot be null");
            this.callbacks.setOnDamage(contextConsumer);
            return this;
        }

        @NotNull
        public Builder onMove(@NotNull Consumer<TeleportContext> contextConsumer) {
            Validate.notNull(contextConsumer, (String)"contextConsumer cannot be null");
            this.callbacks.setOnMove(contextConsumer);
            return this;
        }

        @NotNull
        public Builder onCountdown(@NotNull Consumer<TeleportContext> contextConsumer) {
            Validate.notNull(contextConsumer, (String)"contextConsumer cannot be null");
            this.callbacks.setOnCountdown(contextConsumer);
            return this;
        }

        @NotNull
        public Builder onTeleport(@NotNull Consumer<TeleportContext> contextConsumer) {
            Validate.notNull(contextConsumer, (String)"contextConsumer cannot be null");
            this.callbacks.setOnTeleport(contextConsumer);
            return this;
        }

        @NotNull
        public Builder onCancel(@NotNull Consumer<TeleportContext> contextConsumer) {
            Validate.notNull(contextConsumer, (String)"contextConsumer cannot be null");
            this.callbacks.setOnCancel(contextConsumer);
            return this;
        }

        @NotNull
        public TeleportTask build() {
            return new TeleportTask(this.player, this.player.getLocation(), this.destination, this.callbacks, this.delayTicks, this.movementThreshold);
        }

        @NotNull
        public TeleportTask initiate(@NotNull AlpinePlugin plugin) {
            TeleportTask task = this.build();
            plugin.getTeleportManager().initiateTeleport(task);
            return task;
        }

        @Generated
        public Builder(Player player, Location destination) {
            this.player = player;
            this.destination = destination;
        }
    }
}

