/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.cooldown;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.cooldown.Cooldown;
import co.crystaldev.alpinecore.framework.cooldown.CooldownCallbacks;
import co.crystaldev.alpinecore.framework.cooldown.CooldownListener;
import co.crystaldev.alpinecore.framework.cooldown.DummyCooldown;
import co.crystaldev.alpinecore.framework.cooldown.Warmup;
import co.crystaldev.alpinecore.util.Messaging;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CooldownHandler<T> {
    private final int delayTicks;
    private final double movementThreshold;
    private final CooldownCallbacks<T> callbacks;
    private final Map<T, Cooldown<T>> cooldowns = new ConcurrentHashMap<T, Cooldown<T>>();

    private CooldownHandler(@NotNull AlpinePlugin plugin, int delayTicks, double movementThreshold, @NotNull CooldownCallbacks<T> callbacks) {
        this.delayTicks = delayTicks;
        this.movementThreshold = movementThreshold;
        this.callbacks = callbacks;
        Bukkit.getPluginManager().registerEvents(new CooldownListener<T>(this, this.cooldowns), (Plugin)plugin);
    }

    @NotNull
    public Cooldown<T> testCooldown(@NotNull T key) {
        Location origin = key instanceof Player ? ((Player)key).getLocation() : null;
        Cooldown cooldown = this.cooldowns.getOrDefault(key, DummyCooldown.instance());
        if (!cooldown.isActive()) {
            Cooldown<T> newCooldown = new Cooldown<T>(key, this.delayTicks, this.movementThreshold < 0.0, origin);
            this.cooldowns.put(key, newCooldown);
            this.callbacks.getOnInit().accept(newCooldown);
            if (key instanceof Player) {
                Messaging.send((CommandSender)((Player)key), cooldown.messageType(), cooldown.message());
            }
            if (newCooldown.isCancelled()) {
                this.cancel(key);
            }
        }
        return cooldown;
    }

    @NotNull
    public Cooldown<T> testWarmup(@NotNull T key, @NotNull Consumer<Cooldown<T>> onComplete) {
        Location origin = key instanceof Player ? ((Player)key).getLocation() : null;
        Cooldown<T> warmup = this.cooldowns.get(key);
        if (warmup == null || warmup.isActive()) {
            warmup = new Warmup<T>(key, this.delayTicks, this.movementThreshold < 0.0, origin, onComplete);
            this.cooldowns.put(key, warmup);
            this.callbacks.getOnInit().accept(warmup);
            if (key instanceof Player) {
                Messaging.send((CommandSender)((Player)key), warmup.messageType(), warmup.message());
            }
            if (warmup.isCancelled()) {
                this.cancel(key);
            }
        }
        return warmup;
    }

    public void cancel(@NotNull T key) {
        Cooldown<T> cooldown = this.cooldowns.remove(key);
        if (cooldown != null) {
            cooldown.cancel();
            this.callbacks.getOnCancel().accept(cooldown);
        }
    }

    @Nullable
    public Cooldown<T> get(@NotNull T key) {
        return this.cooldowns.get(key);
    }

    @NotNull
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated
    public double getMovementThreshold() {
        return this.movementThreshold;
    }

    @Generated
    public CooldownCallbacks<T> getCallbacks() {
        return this.callbacks;
    }

    public static final class Builder<T> {
        private int delayTicks;
        private double movementThreshold = 0.1;
        private final CooldownCallbacks<T> callbacks = new CooldownCallbacks();

        @NotNull
        public Builder<T> delay(int ticks) {
            this.delayTicks = ticks;
            return this;
        }

        @NotNull
        public Builder<T> delay(int time, @NotNull TimeUnit unit) {
            this.delayTicks = Math.toIntExact(unit.toMillis(time) / 50L);
            return this;
        }

        @NotNull
        public Builder<T> instant() {
            this.delayTicks = -1;
            return this;
        }

        @NotNull
        public Builder<T> movementThreshold(double threshold) {
            this.movementThreshold = threshold;
            return this;
        }

        @NotNull
        public Builder<T> allowMovement() {
            this.movementThreshold = -1.0;
            return this;
        }

        @NotNull
        public Builder<T> onInit(@NotNull Consumer<Cooldown<T>> contextConsumer) {
            Validate.notNull(contextConsumer, (String)"contextConsumer cannot be null");
            this.callbacks.setOnInit(contextConsumer);
            return this;
        }

        @NotNull
        public Builder<T> onMove(@NotNull Consumer<Cooldown<T>> contextConsumer) {
            Validate.notNull(contextConsumer, (String)"contextConsumer cannot be null");
            this.callbacks.setOnMove(contextConsumer);
            return this;
        }

        @NotNull
        public Builder<T> onCountdown(@NotNull Consumer<Cooldown<T>> contextConsumer) {
            Validate.notNull(contextConsumer, (String)"contextConsumer cannot be null");
            this.callbacks.setOnCountdown(contextConsumer);
            return this;
        }

        @NotNull
        public Builder<T> onComplete(@NotNull Consumer<Cooldown<T>> contextConsumer) {
            Validate.notNull(contextConsumer, (String)"contextConsumer cannot be null");
            this.callbacks.setOnComplete(contextConsumer);
            return this;
        }

        @NotNull
        public Builder<T> onCancel(@NotNull Consumer<Cooldown<T>> contextConsumer) {
            Validate.notNull(contextConsumer, (String)"contextConsumer cannot be null");
            this.callbacks.setOnCancel(contextConsumer);
            return this;
        }

        @NotNull
        public CooldownHandler<T> build(@NotNull AlpinePlugin plugin) {
            return new CooldownHandler(plugin, this.delayTicks, this.movementThreshold, this.callbacks);
        }
    }
}

