/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.config.object.item;

import co.crystaldev.alpinecore.framework.config.object.item.ConfigItem;
import co.crystaldev.alpinecore.framework.config.object.item.ConfigItemAdapter;
import co.crystaldev.alpinecore.framework.config.object.item.DefinedConfigItem;
import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XItemFlag;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XPotion;
import de.exlll.configlib.Configuration;
import de.exlll.configlib.SerializeWith;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Configuration
@SerializeWith(serializer=Adapter.class)
public class VaryingConfigItem
implements ConfigItem {
    protected String name;
    protected List<String> lore;
    protected int count = -1;
    protected boolean enchanted;
    protected Map<String, Object> attributes;

    @NotNull
    public DefinedConfigItem define(@NotNull XMaterial type) {
        return new DefinedConfigItem(type, this.name, this.lore, this.count, this.enchanted, this.attributes);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public VaryingConfigItem() {
    }

    @Generated
    public VaryingConfigItem(String name, List<String> lore, int count, boolean enchanted, Map<String, Object> attributes) {
        this.name = name;
        this.lore = lore;
        this.count = count;
        this.enchanted = enchanted;
        this.attributes = attributes;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @Override
    @Generated
    public int getCount() {
        return this.count;
    }

    @Override
    @Generated
    public boolean isEnchanted() {
        return this.enchanted;
    }

    @Override
    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static final class Builder {
        private String name;
        private List<String> lore;
        private int count = -1;
        private boolean enchanted;
        private Map<String, Object> attributes;

        @NotNull
        public Builder name(@NotNull String name) {
            Validate.notNull((Object)name, (String)"name cannot be null");
            this.name = name;
            return this;
        }

        @NotNull
        public Builder lore(String ... lore) {
            Validate.notNull((Object)lore, (String)"lore cannot be null");
            LinkedList<String> processedLore = new LinkedList<String>();
            for (String s : lore) {
                processedLore.addAll(Arrays.asList(s.split("(\n|<br>)")));
            }
            this.lore = processedLore;
            return this;
        }

        @NotNull
        public Builder lore(@NotNull Iterable<String> lore) {
            Validate.notNull(lore, (String)"lore cannot be null");
            LinkedList<String> processedLore = new LinkedList<String>();
            for (String s : lore) {
                processedLore.addAll(Arrays.asList(s.split("(\n|<br>)")));
            }
            this.lore = processedLore;
            return this;
        }

        @NotNull
        public Builder lore(@NotNull Component lore) {
            Validate.notNull((Object)lore, (String)"lore cannot be null");
            PlainTextComponentSerializer serializer = PlainTextComponentSerializer.plainText();
            String serialized = serializer.serialize(lore);
            this.lore = new LinkedList<String>(Arrays.asList(serialized.split("(\n|<br>)")));
            return this;
        }

        @NotNull
        public Builder count(int count) {
            this.count = count;
            return this;
        }

        @NotNull
        public Builder enchanted() {
            this.enchanted = true;
            return this;
        }

        @NotNull
        public Builder flag(@NotNull XItemFlag flag, boolean value) {
            return this.attribute("flag_" + flag.name().toLowerCase(), value);
        }

        @NotNull
        public Builder enchant(@NotNull XEnchantment enchantment, int level) {
            return this.attribute("enchant_" + enchantment.name().toLowerCase(), level);
        }

        @NotNull
        public Builder potion(@NotNull XPotion effect, int duration, int amplifier) {
            return this.attribute("effect_" + effect.name().toLowerCase(), duration + " " + amplifier);
        }

        @NotNull
        public Builder primaryPotion(@NotNull XPotion effect) {
            return this.attribute("primary_effect", effect.name().toLowerCase());
        }

        @NotNull
        public Builder potionColor(@NotNull Color color) {
            return this.attribute("potion_color", color.asRGB());
        }

        @NotNull
        public Builder attribute(@NotNull String key, @Nullable Object value) {
            if (this.attributes == null) {
                if (value == null) {
                    return this;
                }
                this.attributes = new LinkedHashMap<String, Object>();
            }
            this.attributes.put(key, value);
            return this;
        }

        @NotNull
        public Builder attributes(@NotNull Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        @NotNull
        public VaryingConfigItem build() {
            String name = this.name == null ? "" : this.name;
            List<String> lore = this.lore == null ? Collections.emptyList() : this.lore;
            return new VaryingConfigItem(name, lore, this.count, this.enchanted, this.attributes);
        }
    }

    static final class Adapter
    extends ConfigItemAdapter {
        Adapter() {
        }

        @Override
        public boolean requiresType() {
            return false;
        }
    }
}

