/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.config;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.config.AlpineConfig;
import co.crystaldev.alpinecore.framework.storage.SerializerRegistry;
import co.crystaldev.alpinecore.util.XModuleSerializer;
import com.cryptomorin.xseries.XAttribute;
import com.cryptomorin.xseries.XBiome;
import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XPatternType;
import com.cryptomorin.xseries.XSound;
import de.exlll.configlib.ConfigLib;
import de.exlll.configlib.YamlConfigurationProperties;
import de.exlll.configlib.YamlConfigurations;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class ConfigManager {
    private final Path rootDirectory;
    private final Map<Class<? extends AlpineConfig>, AlpineConfig> registeredConfigurations = new HashMap<Class<? extends AlpineConfig>, AlpineConfig>();
    public final YamlConfigurationProperties properties;

    public ConfigManager(@NotNull AlpinePlugin plugin, @NotNull SerializerRegistry serializerRegistry) {
        this.rootDirectory = plugin.getDataFolder().toPath();
        if (!Files.exists(this.rootDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(this.rootDirectory, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to generate configuration root directory", ex);
            }
        }
        YamlConfigurationProperties.Builder builder = (YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)ConfigLib.BUKKIT_DEFAULT_PROPERTIES.toBuilder().inputNulls(true)).outputNulls(true)).charset(StandardCharsets.UTF_8)).addSerializerByCondition(type -> type instanceof Class && XAttribute.class.isAssignableFrom((Class)type), new XModuleSerializer(XAttribute.class))).addSerializerByCondition(type -> type instanceof Class && XBiome.class.isAssignableFrom((Class)type), new XModuleSerializer(XBiome.class))).addSerializerByCondition(type -> type instanceof Class && XEnchantment.class.isAssignableFrom((Class)type), new XModuleSerializer(XEnchantment.class))).addSerializerByCondition(type -> type instanceof Class && XPatternType.class.isAssignableFrom((Class)type), new XModuleSerializer(XPatternType.class))).addSerializerByCondition(type -> type instanceof Class && XSound.class.isAssignableFrom((Class)type), new XModuleSerializer(XSound.class));
        serializerRegistry.getConfigSerializers().forEach((dataType, serializer) -> builder.addSerializer(dataType, serializer));
        this.properties = builder.build();
    }

    @NotNull
    public <T extends AlpineConfig> T getConfig(@NotNull Class<T> clazz) {
        AlpineConfig config = this.registeredConfigurations.get(clazz);
        if (config != null) {
            return (T)config;
        }
        throw new IllegalStateException("There was no configuration registered for that type");
    }

    @NotNull
    public <T extends AlpineConfig> T loadConfig(@NotNull T config) {
        Path file = this.rootDirectory.resolve(Paths.get(config.getFileName(), new String[0]));
        Class<?> clazz = config.getClass();
        return (T)((AlpineConfig)YamlConfigurations.update(file, clazz, this.properties));
    }

    @NotNull
    public <T extends AlpineConfig> T registerConfig(@NotNull T config) {
        config = this.loadConfig(config);
        Class<?> clazz = config.getClass();
        this.registeredConfigurations.put(clazz, config);
        return config;
    }

    @NotNull
    public <T extends AlpineConfig> T editConfig(@NotNull T config, @NotNull Consumer<T> consumer) {
        Path file = this.rootDirectory.resolve(Paths.get(config.getFileName(), new String[0]));
        config = this.registerConfig(config);
        consumer.accept(config);
        YamlConfigurations.save(file, config.getClass(), config, this.properties);
        return config;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void unregisterConfig(@NotNull AlpineConfig config) {
        Class<@NotNull ?> clazz = config.getClass();
        this.registeredConfigurations.remove(clazz);
    }

    public boolean isRegistered(@NotNull AlpineConfig config) {
        Class<?> clazz = config.getClass();
        return this.registeredConfigurations.containsKey(clazz);
    }

    public <T extends AlpineConfig> boolean isRegistered(@NotNull Class<T> clazz) {
        return this.registeredConfigurations.containsKey(clazz);
    }

    @Generated
    public Path getRootDirectory() {
        return this.rootDirectory;
    }
}

