/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.permission;

import dev.rollczi.litecommands.meta.Meta;
import dev.rollczi.litecommands.meta.MetaHolder;
import dev.rollczi.litecommands.permission.PermissionResolver;
import dev.rollczi.litecommands.permission.PermissionSet;
import dev.rollczi.litecommands.permission.PermissionValidationResult;
import dev.rollczi.litecommands.platform.PlatformSender;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.Nullable;

public class PermissionDefaultResolver
implements PermissionResolver {
    private final BiPredicate<PlatformSender, String> hasPermission;

    public PermissionDefaultResolver(BiPredicate<PlatformSender, String> hasPermission) {
        this.hasPermission = hasPermission;
    }

    public <SENDER> PermissionDefaultResolver(Class<SENDER> type, BiPredicate<SENDER, String> hasPermission) {
        this.hasPermission = (sender, permission) -> {
            Object handle = sender.getHandle();
            if (!type.isAssignableFrom(handle.getClass())) {
                return false;
            }
            return hasPermission.test((Object)type.cast(handle), (String)permission);
        };
    }

    @Override
    public List<PermissionValidationResult.Verdict> resolve(PlatformSender sender, MetaHolder metaHolder) {
        @Nullable MetaHolder current = metaHolder;
        ArrayList<PermissionValidationResult.Verdict> results = new ArrayList<PermissionValidationResult.Verdict>();
        while (current != null) {
            if (!current.meta().has(Meta.PERMISSIONS)) {
                current = current.parentMeta();
                continue;
            }
            results.add(this.checkCurrent(sender, current));
            current = current.parentMeta();
        }
        return results;
    }

    private PermissionValidationResult.Verdict checkCurrent(PlatformSender sender, MetaHolder current) {
        ArrayList<PermissionValidationResult.Check> checks = new ArrayList<PermissionValidationResult.Check>();
        for (PermissionSet permissionSet : current.meta().get(Meta.PERMISSIONS)) {
            ArrayList<String> checked = new ArrayList<String>();
            ArrayList<String> missing = new ArrayList<String>();
            for (String permission : permissionSet.getPermissions()) {
                checked.add(permission);
                if (this.hasPermission.test(sender, permission)) continue;
                missing.add(permission);
            }
            if (missing.isEmpty()) {
                return PermissionValidationResult.Verdict.permitted(current);
            }
            checks.add(new PermissionValidationResult.Check(checked, missing));
        }
        return new PermissionValidationResult.Verdict(current, checks);
    }
}

