/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.invalidusage;

import dev.rollczi.litecommands.command.CommandRoute;
import dev.rollczi.litecommands.command.executor.CommandExecuteResult;
import dev.rollczi.litecommands.command.executor.CommandExecutor;
import dev.rollczi.litecommands.command.executor.event.CommandPostExecutionEvent;
import dev.rollczi.litecommands.event.EventListener;
import dev.rollczi.litecommands.event.Subscriber;
import dev.rollczi.litecommands.invalidusage.InvalidUsage;
import dev.rollczi.litecommands.invocation.Invocation;
import dev.rollczi.litecommands.schematic.Schematic;
import dev.rollczi.litecommands.schematic.SchematicGenerator;
import dev.rollczi.litecommands.schematic.SchematicInput;
import org.jetbrains.annotations.Nullable;

public class InvalidUsageResultController<SENDER>
implements EventListener {
    private final SchematicGenerator<SENDER> schematicGenerator;

    public InvalidUsageResultController(SchematicGenerator<SENDER> schematicGenerator) {
        this.schematicGenerator = schematicGenerator;
    }

    @Subscriber
    public void onEvent(CommandPostExecutionEvent<SENDER> event) {
        Object error;
        CommandExecutor<SENDER> executor = event.getExecutor();
        CommandRoute<SENDER> commandRoute = event.getCommandRoute();
        Invocation<SENDER> invocation = event.getInvocation();
        CommandExecuteResult executeResult = event.getResult();
        Object result = executeResult.getResult();
        if (result != null) {
            event.setResult(CommandExecuteResult.success(executor, this.mapResult(result, commandRoute, executeResult, invocation)));
        }
        if ((error = executeResult.getError()) != null) {
            Object mapped = this.mapResult(error, commandRoute, executeResult, invocation);
            if (executor == null) {
                event.setResult(CommandExecuteResult.failed(mapped));
                return;
            }
            event.setResult(CommandExecuteResult.failed(executor, mapped));
        }
    }

    private Object mapResult(Object error, CommandRoute<SENDER> commandRoute, CommandExecuteResult executeResult, Invocation<SENDER> invocation) {
        if (error instanceof InvalidUsage.Cause) {
            InvalidUsage.Cause cause = (InvalidUsage.Cause)((Object)error);
            @Nullable CommandExecutor<?> executor = executeResult.getExecutor();
            Schematic schematic = this.schematicGenerator.generate(new SchematicInput<SENDER>(commandRoute, executor, invocation));
            return new InvalidUsage<SENDER>(cause, commandRoute, schematic);
        }
        return error;
    }
}

