/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionHelper {
    @Nullable
    public static Field findField(@NotNull Class<?> clazz, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            try {
                Field f = clazz.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Nullable
    public static <T, E> T getPrivateValue(@NotNull Class<? super E> classToAccess, @NotNull E instance, String ... fieldNames) {
        try {
            Field field = ReflectionHelper.findField(classToAccess, fieldNames);
            if (field != null) {
                return (T)field.get(instance);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static <T, E> void setPrivateValue(@NotNull Class<? super T> classToAccess, @NotNull T instance, @Nullable E value, String ... fieldNames) {
        try {
            Field field = ReflectionHelper.findField(classToAccess, fieldNames);
            if (field != null) {
                field.set(instance, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Nullable
    public static Class<? super Object> getClass(@NotNull ClassLoader loader, String ... classNames) {
        for (String className : classNames) {
            try {
                return Class.forName(className, false, loader);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Nullable
    public static Class<? super Object> getClass(@NotNull ClassLoader loader, @NotNull String className) {
        try {
            return Class.forName(className, false, loader);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static Method findMethod(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... parameterTypes) {
        try {
            Method m = clazz.getDeclaredMethod(methodName, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static Method findMethod(@NotNull Class<?> clazz, @NotNull String[] methodNames, Class<?> ... parameterTypes) {
        for (String name : methodNames) {
            try {
                Method m = clazz.getDeclaredMethod(name, parameterTypes);
                m.setAccessible(true);
                return m;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Nullable
    public static Constructor<?> findConstructor(@NotNull Class<?> clazz, @NotNull Class<?> parameterTypes) {
        try {
            Constructor<?> constructor = clazz.getConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Nullable
    public static <R> R invokeMethod(@NotNull Method method, @Nullable Object source, Object ... parameters) {
        try {
            return (R)method.invoke(source, parameters);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static <R> R invokeMethod(@NotNull Class<R> returnType, @NotNull Method method, @Nullable Object source, Object ... parameters) {
        try {
            Object returnedValue = method.invoke(source, parameters);
            if (returnedValue != null && returnedValue.getClass().isInstance(returnType)) {
                return (R)returnedValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static <R> R invokeConstructor(@NotNull Constructor<R> constructor, Object ... parameters) {
        try {
            return constructor.newInstance(parameters);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Generated
    private ReflectionHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

