/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Components {
    private static final Map<StyleBuilderApplicable, List<String>> STYLE_TO_ALIAS_MAP = ImmutableMap.builder().put((Object)TextDecoration.BOLD, (Object)ImmutableList.of((Object)"bold", (Object)"&l", (Object)"l")).put((Object)TextDecoration.ITALIC, (Object)ImmutableList.of((Object)"italic", (Object)"&o", (Object)"o")).put((Object)TextDecoration.OBFUSCATED, (Object)ImmutableList.of((Object)"obfuscated", (Object)"&k", (Object)"k", (Object)"magic")).put((Object)TextDecoration.UNDERLINED, (Object)ImmutableList.of((Object)"underlined", (Object)"&n", (Object)"n", (Object)"underline", (Object)"uline")).put((Object)TextDecoration.STRIKETHROUGH, (Object)ImmutableList.of((Object)"strikethrough", (Object)"&m", (Object)"m", (Object)"strike")).put((Object)NamedTextColor.BLACK, (Object)ImmutableList.of((Object)"black", (Object)"&0", (Object)"0")).put((Object)NamedTextColor.DARK_BLUE, (Object)ImmutableList.of((Object)"dark_blue", (Object)"&1", (Object)"1")).put((Object)NamedTextColor.DARK_GREEN, (Object)ImmutableList.of((Object)"dark_green", (Object)"&2", (Object)"2")).put((Object)NamedTextColor.DARK_AQUA, (Object)ImmutableList.of((Object)"dark_aqua", (Object)"&3", (Object)"3")).put((Object)NamedTextColor.DARK_RED, (Object)ImmutableList.of((Object)"dark_red", (Object)"&4", (Object)"4")).put((Object)NamedTextColor.DARK_PURPLE, (Object)ImmutableList.of((Object)"dark_purple", (Object)"&5", (Object)"5", (Object)"dark_magenta")).put((Object)NamedTextColor.GOLD, (Object)ImmutableList.of((Object)"gold", (Object)"&6", (Object)"6")).put((Object)NamedTextColor.GRAY, (Object)ImmutableList.of((Object)"gray", (Object)"grey", (Object)"&7", (Object)"7")).put((Object)NamedTextColor.DARK_GRAY, (Object)ImmutableList.of((Object)"dark_gray", (Object)"dark_grey", (Object)"&8", (Object)"8")).put((Object)NamedTextColor.BLUE, (Object)ImmutableList.of((Object)"blue", (Object)"&9", (Object)"9")).put((Object)NamedTextColor.GREEN, (Object)ImmutableList.of((Object)"green", (Object)"&a", (Object)"a")).put((Object)NamedTextColor.AQUA, (Object)ImmutableList.of((Object)"aqua", (Object)"&b", (Object)"b")).put((Object)NamedTextColor.RED, (Object)ImmutableList.of((Object)"red", (Object)"&c", (Object)"c")).put((Object)NamedTextColor.LIGHT_PURPLE, (Object)ImmutableList.of((Object)"light_purple", (Object)"&d", (Object)"d", (Object)"magenta", (Object)"purple")).put((Object)NamedTextColor.YELLOW, (Object)ImmutableList.of((Object)"yellow", (Object)"&e", (Object)"e")).put((Object)NamedTextColor.WHITE, (Object)ImmutableList.of((Object)"white", (Object)"&f", (Object)"f")).build();

    @NotNull
    public static Component reset() {
        Style.Builder style = Style.style().color(NamedTextColor.WHITE);
        for (TextDecoration value : TextDecoration.values()) {
            style.decoration(value, TextDecoration.State.FALSE);
        }
        return ((TextComponent)Component.text("").color(NamedTextColor.WHITE)).style(style.build());
    }

    public static int length(@Nullable Component component) {
        if (component == null) {
            return 0;
        }
        return PlainTextComponentSerializer.plainText().serialize(component).length();
    }

    @NotNull
    public static Component joinSeparated(@NotNull ComponentLike separator, Component ... components) {
        return Component.join(JoinConfiguration.separator(separator), (ComponentLike[])components);
    }

    @NotNull
    public static Component joinSeparated(@NotNull ComponentLike separator, @NotNull Iterable<Component> components) {
        return Component.join(JoinConfiguration.separator(separator), components);
    }

    @NotNull
    public static Component join(Component ... components) {
        return Components.joinSeparated((ComponentLike)Component.empty(), components);
    }

    @NotNull
    public static Component join(@NotNull Iterable<Component> components) {
        return Components.joinSeparated((ComponentLike)Component.empty(), components);
    }

    @NotNull
    public static Component joinSpaces(Component ... components) {
        return Components.joinSeparated((ComponentLike)Component.space(), components);
    }

    @NotNull
    public static Component joinSpaces(@NotNull Iterable<Component> components) {
        return Components.joinSeparated((ComponentLike)Component.space(), components);
    }

    @NotNull
    public static Component joinCommas(Component ... components) {
        return Components.joinSeparated((ComponentLike)Component.text(", "), components);
    }

    @NotNull
    public static Component joinCommas(@NotNull Iterable<Component> components) {
        return Components.joinSeparated((ComponentLike)Component.text(", "), components);
    }

    @NotNull
    public static Component joinNewLines(Component ... components) {
        return Components.joinSeparated((ComponentLike)Component.newline(), components);
    }

    @NotNull
    public static Component joinNewLines(@NotNull Iterable<Component> components) {
        return Components.joinSeparated((ComponentLike)Component.newline(), components);
    }

    @NotNull
    public static Component events(@NotNull Component component, @NotNull Component hover, @NotNull String command) {
        return component.hoverEvent(HoverEvent.showText(hover)).clickEvent(ClickEvent.runCommand(command));
    }

    @NotNull
    public static Component events(@NotNull Component component, @NotNull Component both) {
        return Components.events(component, both, PlainTextComponentSerializer.plainText().serialize(both));
    }

    @NotNull
    public static Component events(@NotNull Component component, @NotNull String both) {
        return Components.events(component, Component.text(both), both);
    }

    @NotNull
    public static Component stylize(@Nullable String style, @NotNull Component component, boolean force) {
        if (style == null) {
            return component;
        }
        if (!force) {
            return Components.stylize(style, component);
        }
        for (StyleBuilderApplicable type : Components.processStyle(style)) {
            if (type instanceof TextColor) {
                component = component.color((TextColor)type);
                continue;
            }
            component = component.decorate((TextDecoration)type);
        }
        return component;
    }

    @NotNull
    public static Component stylize(@Nullable String style, @NotNull Component component) {
        if (style == null) {
            return component;
        }
        TextComponent.Builder builder = Component.text();
        for (StyleBuilderApplicable type : Components.processStyle(style)) {
            if (type instanceof TextColor) {
                builder.color((TextColor)type);
                continue;
            }
            builder.decorate((TextDecoration)type);
        }
        builder.append(component);
        return builder.asComponent();
    }

    @ApiStatus.Internal
    @NotNull
    public static List<StyleBuilderApplicable> processStyle(@NotNull String style) {
        ArrayList<StyleBuilderApplicable> styles = new ArrayList<StyleBuilderApplicable>();
        for (String component : style.split(" +")) {
            StyleBuilderApplicable parsedComponent = null;
            for (Map.Entry<StyleBuilderApplicable, List<String>> entry : STYLE_TO_ALIAS_MAP.entrySet()) {
                List<String> aliases = entry.getValue();
                if (!aliases.contains(component.toLowerCase())) continue;
                parsedComponent = entry.getKey();
                break;
            }
            if (parsedComponent == null) {
                if (!component.startsWith("#")) {
                    component = "#" + component;
                }
                parsedComponent = TextColor.fromHexString(component);
            }
            if (parsedComponent == null) continue;
            styles.add(parsedComponent);
        }
        return styles;
    }

    @NotNull
    public static List<Component> split(@NotNull Component self, @NotNull @RegExp String separator) {
        List<Component> lines = Components.splitComponentContent(self, separator);
        if (self.children().isEmpty()) {
            return lines;
        }
        Component parent = lines.remove(lines.size() - 1);
        for (Component child : self.children()) {
            List<Component> childSegments = Components.split(child, separator);
            parent = parent.append(childSegments.get(0));
            for (int i = 1; i < childSegments.size(); ++i) {
                lines.add(parent);
                parent = Component.empty().style(parent.style());
                parent = parent.append(childSegments.get(i));
            }
        }
        lines.add(parent);
        return lines;
    }

    @NotNull
    private static List<Component> splitComponentContent(@NotNull Component component, @RegExp String regex) {
        if (!(component instanceof TextComponent)) {
            return Collections.singletonList(component);
        }
        TextComponent textComponent = (TextComponent)component;
        String[] segments = textComponent.content().split(regex);
        if (segments.length == 0) {
            segments = new String[]{"", ""};
        }
        return Arrays.stream(segments).map(s -> (TextComponent)Component.text(s).style(textComponent.style())).map(c -> c).collect(Collectors.toList());
    }

    @Generated
    private Components() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

