/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.integration;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.integration.AlpineIntegration;
import co.crystaldev.alpinecore.framework.integration.AlpineIntegrationEngine;
import java.util.List;
import lombok.Generated;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VaultIntegration
extends AlpineIntegration {
    private static VaultIntegration instance;

    private VaultIntegration(AlpinePlugin plugin) {
        super(plugin);
        instance = this;
    }

    @Override
    protected boolean shouldActivate() {
        return this.plugin.getServer().getPluginManager().isPluginEnabled("Vault");
    }

    @Override
    @NotNull
    protected Class<? extends AlpineIntegrationEngine> getEngineClass() {
        return VaultEngine.class;
    }

    @Override
    @NotNull
    public VaultEngine getEngine() {
        VaultEngine engine = (VaultEngine)super.getEngine();
        if (engine == null) {
            throw new IllegalStateException("Vault not installed");
        }
        return engine;
    }

    @Generated
    public static VaultIntegration getInstance() {
        return instance;
    }

    public static final class VaultEngine
    extends AlpineIntegrationEngine {
        private static final EconomyResponse NO_ECONOMY = new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "No economy provider was registered");

        private VaultEngine(AlpinePlugin plugin) {
            super(plugin);
        }

        @Nullable
        public Economy getEconomy() {
            RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Economy.class);
            if (rsp == null) {
                return null;
            }
            return (Economy)rsp.getProvider();
        }

        @Nullable
        public String getEconomyName() {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return null;
            }
            return econ.getName();
        }

        @Nullable
        public String getCurrencyNameSingular() {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return null;
            }
            return econ.currencyNameSingular();
        }

        @Nullable
        public String getCurrencyNamePlural() {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return null;
            }
            return econ.currencyNamePlural();
        }

        public boolean isEconomyEnabled() {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return false;
            }
            return econ.isEnabled();
        }

        public boolean doesEconomySupportBanks() {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return false;
            }
            return econ.hasBankSupport();
        }

        public int getEconomyFractionalDigits() {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return 0;
            }
            return econ.fractionalDigits();
        }

        @Nullable
        public String formatAmount(double amount) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return null;
            }
            return econ.format(amount);
        }

        public boolean hasAccount(@NotNull OfflinePlayer player) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return false;
            }
            return econ.hasAccount(player);
        }

        public boolean hasAccountInWorld(@NotNull OfflinePlayer player, @NotNull String world) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return false;
            }
            return econ.hasAccount(player, world);
        }

        public double getBalance(@NotNull OfflinePlayer player) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return 0.0;
            }
            return econ.getBalance(player);
        }

        public double getBalanceInWorld(@NotNull OfflinePlayer player, @NotNull String world) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return 0.0;
            }
            return econ.getBalance(player, world);
        }

        public boolean hasFunds(@NotNull OfflinePlayer player, double amount) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return false;
            }
            return econ.has(player, amount);
        }

        public boolean hasFundsInWorld(@NotNull OfflinePlayer player, @NotNull String world, double amount) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return false;
            }
            return econ.has(player, world, amount);
        }

        @NotNull
        public EconomyResponse withdrawFunds(@NotNull OfflinePlayer player, double amount) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return NO_ECONOMY;
            }
            return econ.withdrawPlayer(player, amount);
        }

        public boolean withdrawFundsSimple(@NotNull OfflinePlayer player, double amount) {
            return this.withdrawFunds(player, amount).transactionSuccess();
        }

        @NotNull
        public EconomyResponse withdrawFundsInWorld(@NotNull OfflinePlayer player, @NotNull String world, double amount) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return NO_ECONOMY;
            }
            return econ.withdrawPlayer(player, world, amount);
        }

        public boolean withdrawFundsInWorldSimple(@NotNull OfflinePlayer player, @NotNull String world, double amount) {
            return this.withdrawFundsInWorld(player, world, amount).transactionSuccess();
        }

        @NotNull
        public EconomyResponse depositFunds(@NotNull OfflinePlayer player, double amount) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return NO_ECONOMY;
            }
            return econ.depositPlayer(player, amount);
        }

        public boolean depositFundsSimple(@NotNull OfflinePlayer player, double amount) {
            return this.depositFunds(player, amount).transactionSuccess();
        }

        @NotNull
        public EconomyResponse depositFundsInWorld(@NotNull OfflinePlayer player, @NotNull String world, double amount) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return NO_ECONOMY;
            }
            return econ.depositPlayer(player, world, amount);
        }

        public boolean depositFundsInWorldSimple(@NotNull OfflinePlayer player, @NotNull String world, double amount) {
            return this.depositFundsInWorld(player, world, amount).transactionSuccess();
        }

        @NotNull
        public EconomyResponse createBank(@NotNull OfflinePlayer player, @NotNull String name) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return NO_ECONOMY;
            }
            return econ.createBank(name, player);
        }

        public boolean createBankSimple(@NotNull OfflinePlayer player, @NotNull String name) {
            return this.createBank(player, name).transactionSuccess();
        }

        @NotNull
        public EconomyResponse deleteBank(@NotNull String name) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return NO_ECONOMY;
            }
            return econ.deleteBank(name);
        }

        public boolean deleteBankSimple(@NotNull String name) {
            return this.deleteBank(name).transactionSuccess();
        }

        @NotNull
        public EconomyResponse checkBankBalance(@NotNull String name) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return NO_ECONOMY;
            }
            return econ.bankBalance(name);
        }

        public double checkBankBalanceSimple(@NotNull String name) {
            EconomyResponse response = this.checkBankBalance(name);
            return response.balance;
        }

        @NotNull
        public EconomyResponse bankHasFunds(@NotNull String name, double amount) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return NO_ECONOMY;
            }
            return econ.bankHas(name, amount);
        }

        public boolean bankHasFundsSimple(@NotNull String name, double amount) {
            return this.bankHasFunds(name, amount).transactionSuccess();
        }

        @NotNull
        public EconomyResponse bankWithdrawFunds(@NotNull String name, double amount) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return NO_ECONOMY;
            }
            return econ.bankWithdraw(name, amount);
        }

        public boolean bankWithdrawFundsSimple(@NotNull String name, double amount) {
            return this.bankWithdrawFunds(name, amount).transactionSuccess();
        }

        @NotNull
        public EconomyResponse bankDepositFunds(@NotNull String name, double amount) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return NO_ECONOMY;
            }
            return econ.bankDeposit(name, amount);
        }

        public boolean bankDepositFundsSimple(@NotNull String name, double amount) {
            return this.bankDepositFunds(name, amount).transactionSuccess();
        }

        public boolean isBankOwner(@NotNull OfflinePlayer player, @NotNull String name) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return false;
            }
            return econ.isBankOwner(name, player).transactionSuccess();
        }

        public boolean isBankMember(@NotNull OfflinePlayer player, @NotNull String name) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return false;
            }
            return econ.isBankMember(name, player).transactionSuccess();
        }

        @Nullable
        public List<String> getBanks() {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return null;
            }
            return econ.getBanks();
        }

        public boolean createAccount(OfflinePlayer player) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return false;
            }
            return econ.createPlayerAccount(player);
        }

        public boolean createAccountInWorld(OfflinePlayer player, String world) {
            Economy econ = this.getEconomy();
            if (econ == null) {
                return false;
            }
            return econ.createPlayerAccount(player, world);
        }
    }
}

