/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui.interaction;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.jetbrains.annotations.NotNull;

public final class ClickProperties {
    public static final ClickProperties ALL_ALLOWED = ClickProperties.builder().actions(InventoryAction.values()).types(ClickType.values()).build();
    public static final ClickProperties ALL_DISALLOWED = ClickProperties.builder().build();
    private final Set<InventoryAction> allowedActions;
    private final Set<ClickType> allowedTypes;

    public boolean isAllowed(@NotNull InventoryAction action) {
        return this.allowedActions.contains(action);
    }

    public boolean isAllowed(@NotNull ClickType type) {
        return this.allowedTypes.contains(type);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    private ClickProperties(Set<InventoryAction> allowedActions, Set<ClickType> allowedTypes) {
        this.allowedActions = allowedActions;
        this.allowedTypes = allowedTypes;
    }

    public static final class Builder {
        private final Set<InventoryAction> allowedActions = new HashSet<InventoryAction>();
        private final Set<ClickType> allowedTypes = new HashSet<ClickType>();

        @NotNull
        public Builder action(@NotNull InventoryAction action) {
            Validate.notNull((Object)action, (String)"action cannot be null");
            this.allowedActions.add(action);
            return this;
        }

        @NotNull
        public Builder actions(InventoryAction ... actions) {
            for (InventoryAction action : actions) {
                this.action(action);
            }
            return this;
        }

        @NotNull
        public Builder type(@NotNull ClickType type) {
            Validate.notNull((Object)type, (String)"type cannot be null");
            this.allowedTypes.add(type);
            return this;
        }

        @NotNull
        public Builder types(ClickType ... types) {
            for (ClickType type : types) {
                this.type(type);
            }
            return this;
        }

        @NotNull
        public ClickProperties build() {
            return new ClickProperties(this.allowedActions, this.allowedTypes);
        }
    }
}

