/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.command;

import dev.rollczi.litecommands.command.CommandRoute;
import dev.rollczi.litecommands.command.executor.CommandExecutor;
import dev.rollczi.litecommands.meta.Meta;
import dev.rollczi.litecommands.meta.MetaCollector;
import dev.rollczi.litecommands.meta.MetaHolder;
import dev.rollczi.litecommands.priority.MutablePrioritizedList;
import dev.rollczi.litecommands.priority.PrioritizedList;
import dev.rollczi.litecommands.shared.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

class CommandRouteImpl<SENDER>
implements CommandRoute<SENDER> {
    private final String name;
    private final UUID uniqueId = UUID.randomUUID();
    private final List<String> aliases;
    private final Set<String> namesAndAliases;
    private final CommandRoute<SENDER> parent;
    private final Meta meta = Meta.create();
    private final MetaCollector metaCollector = MetaCollector.of(this);
    private final MutablePrioritizedList<CommandExecutor<SENDER>> executors = new MutablePrioritizedList();
    private final List<CommandRoute<SENDER>> childRoutes = new ArrayList<CommandRoute<SENDER>>();
    private final Map<String, CommandRoute<SENDER>> childrenByName = new HashMap<String, CommandRoute<SENDER>>();

    CommandRouteImpl(String name, List<String> aliases, CommandRoute<SENDER> parent) {
        this.name = name;
        this.aliases = Collections.unmodifiableList(new ArrayList<String>(aliases));
        this.parent = parent;
        HashSet<String> namesAndAliases = new HashSet<String>(this.aliases);
        namesAndAliases.add(this.name);
        this.namesAndAliases = Collections.unmodifiableSet(namesAndAliases);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public List<String> names() {
        return Collections.unmodifiableList(new ArrayList<String>(this.namesAndAliases));
    }

    @Override
    public boolean isNameOrAlias(String name) {
        return this.namesAndAliases.contains(name);
    }

    @Override
    public CommandRoute<SENDER> getParent() {
        return this.parent;
    }

    @Override
    public List<CommandRoute<SENDER>> getChildren() {
        return Collections.unmodifiableList(this.childRoutes);
    }

    @Override
    public Optional<CommandRoute<SENDER>> getChild(String name) {
        return Optional.ofNullable(this.childrenByName.get(name));
    }

    @Override
    public PrioritizedList<CommandExecutor<SENDER>> getExecutors() {
        return this.executors;
    }

    @Override
    public Meta meta() {
        return this.meta;
    }

    @Override
    public CommandRoute<SENDER> merge(CommandRoute<SENDER> toMerge) {
        if (!this.name.equals(toMerge.getName())) {
            throw new IllegalArgumentException("Cannot merge routes with different names!");
        }
        ArrayList<String> aliases = new ArrayList<String>(this.aliases);
        aliases.addAll(toMerge.getAliases());
        CommandRouteImpl merged = new CommandRouteImpl<SENDER>(this.name, aliases, this.parent){

            @Override
            public boolean isReference() {
                return CommandRouteImpl.this.isReference();
            }
        };
        merged.meta().putAll(this.meta());
        merged.meta().putAll(toMerge.meta());
        for (CommandExecutor commandExecutor : this.getExecutors()) {
            merged.appendExecutor(commandExecutor);
        }
        for (CommandExecutor commandExecutor : toMerge.getExecutors()) {
            merged.appendExecutor(commandExecutor);
        }
        for (CommandRoute commandRoute : this.getChildren()) {
            merged.appendChildren(commandRoute);
        }
        for (CommandRoute commandRoute : toMerge.getChildren()) {
            merged.appendChildren(commandRoute);
        }
        return merged;
    }

    @Override
    @Nullable
    public MetaHolder parentMeta() {
        return this.parent;
    }

    @Override
    public MetaCollector metaCollector() {
        return this.metaCollector;
    }

    @Override
    public void appendChildren(CommandRoute<SENDER> children) {
        for (String name : children.names()) {
            if (!this.childrenByName.containsKey(name)) continue;
            throw new IllegalArgumentException("Route with name or alias '" + name + "' already exists!");
        }
        this.childRoutes.add(children);
        for (String name : children.names()) {
            this.childrenByName.put(name, children);
        }
    }

    @Override
    public void appendExecutor(CommandExecutor<SENDER> executor) {
        Preconditions.notNull(executor, "executor");
        Preconditions.notContains(this.executors, executor, "executors", "executor");
        this.executors.add(executor);
    }

    public String toString() {
        return "CommandRouteImpl{name='" + this.name + '\'' + ", uniqueId=" + this.uniqueId + ", aliases=" + this.aliases + ", meta=" + this.meta + '}';
    }
}

