/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.adventure;

import dev.rollczi.litecommands.LiteCommandsBuilder;
import dev.rollczi.litecommands.LiteCommandsInternal;
import dev.rollczi.litecommands.adventure.AdventureAudienceContextual;
import dev.rollczi.litecommands.adventure.AdventureAudienceProvider;
import dev.rollczi.litecommands.adventure.AdventureColoredComponentArgument;
import dev.rollczi.litecommands.adventure.AdventureComponentArgument;
import dev.rollczi.litecommands.adventure.AdventureComponentHandler;
import dev.rollczi.litecommands.adventure.AdventureJoinComponentResolver;
import dev.rollczi.litecommands.adventure.AdventureMiniMessageFactory;
import dev.rollczi.litecommands.adventure.PlainComponentSerializerFactory;
import dev.rollczi.litecommands.adventure.StringHandler;
import dev.rollczi.litecommands.argument.ArgumentKey;
import dev.rollczi.litecommands.argument.profile.ProfileNamespaces;
import dev.rollczi.litecommands.configurator.LiteConfigurator;
import dev.rollczi.litecommands.extension.LiteExtension;
import dev.rollczi.litecommands.suggestion.SuggestionResult;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;

public class LiteAdventureExtension<SENDER>
implements LiteExtension<SENDER, Settings> {
    private final AdventureAudienceProvider<SENDER> adventureAudienceProvider;
    private final Settings settings = new Settings();

    public LiteAdventureExtension(AdventureAudienceProvider<SENDER> adventureAudienceProvider) {
        this.adventureAudienceProvider = adventureAudienceProvider;
    }

    public LiteAdventureExtension() {
        this.adventureAudienceProvider = AdventureAudienceProvider.simple();
    }

    @Deprecated
    public static <T> LiteAdventureExtension<T> create() {
        return new LiteAdventureExtension();
    }

    @Override
    public void configure(LiteConfigurator<Settings> configurer) {
        configurer.configure(this.settings);
    }

    @Override
    public void extend(LiteCommandsBuilder<SENDER, ?, ?> builder, LiteCommandsInternal<SENDER, ?> internal) {
        if (this.settings.componentSerializer == null) {
            this.settings.componentSerializer = this.settings.supportsMiniMessage ? AdventureMiniMessageFactory.create(this.settings.supportsLegacyColor) : PlainComponentSerializerFactory.create(this.settings.supportsLegacyColor);
        }
        AdventureColoredComponentArgument colored = new AdventureColoredComponentArgument(this.settings.componentSerializer);
        AdventureComponentArgument raw = new AdventureComponentArgument();
        AdventureJoinComponentResolver joinColor = AdventureJoinComponentResolver.colored(this.settings.componentSerializer);
        AdventureJoinComponentResolver joinRaw = AdventureJoinComponentResolver.raw();
        builder.argumentParser(Component.class, this.settings.colorizeArgument ? colored : raw).argumentParser(Component.class, ArgumentKey.of("raw"), raw).argumentParser(Component.class, ArgumentKey.of("color"), colored).argumentSuggester(Component.class, (invocation, argument, context) -> SuggestionResult.of("<" + argument.getName() + ">")).argumentParser(Component.class, ProfileNamespaces.JOIN, this.settings.colorizeArgument ? joinColor : joinRaw).argumentParser(Component.class, ProfileNamespaces.JOIN.withKey("raw"), joinRaw).argumentParser(Component.class, ProfileNamespaces.JOIN.withKey("color"), joinColor).context(Audience.class, new AdventureAudienceContextual<SENDER>(this.adventureAudienceProvider)).result(Component.class, new AdventureComponentHandler<SENDER>(this.adventureAudienceProvider)).result(String.class, new StringHandler<SENDER>(this.adventureAudienceProvider, this.settings.componentSerializer)).bind(ComponentSerializer.class, () -> this.settings.componentSerializer);
    }

    public static class Settings {
        private boolean supportsMiniMessage = false;
        private boolean supportsLegacyColor = false;
        private ComponentSerializer<Component, ? extends Component, String> componentSerializer;
        private boolean colorizeArgument = false;

        public Settings miniMessage(boolean supportsMiniMessage) {
            this.supportsMiniMessage = supportsMiniMessage;
            return this;
        }

        public Settings legacyColor(boolean supportsLegacyColor) {
            this.supportsLegacyColor = supportsLegacyColor;
            return this;
        }

        public Settings colorizeArgument(boolean colorizeArgument) {
            this.colorizeArgument = colorizeArgument;
            return this;
        }

        public Settings serializer(ComponentSerializer<Component, ? extends Component, String> serializer) {
            this.componentSerializer = serializer;
            return this;
        }
    }
}

