/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import co.crystaldev.alpinecore.libs.localelib.LocaleManager;
import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.base.XModule;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class LocaleHelper {
    private static final LocaleManager MANAGER = new LocaleManager();

    @NotNull
    public static String getTranslationKey(@NotNull XMaterial material) {
        try {
            return MANAGER.queryMaterial(material.parseMaterial());
        }
        catch (Exception ex) {
            return LocaleHelper.formatEnum(material.parseMaterial());
        }
    }

    @NotNull
    public static Component getTranslation(@NotNull XMaterial material) {
        try {
            return Component.translatable(MANAGER.queryMaterial(material.parseMaterial()));
        }
        catch (Exception ex) {
            return Component.text(LocaleHelper.formatEnum(material.parseMaterial()));
        }
    }

    @NotNull
    public static String getTranslationKey(@NotNull Material material) {
        try {
            return MANAGER.queryMaterial(material);
        }
        catch (Exception ex) {
            return LocaleHelper.formatEnum(material);
        }
    }

    @NotNull
    public static Component getTranslation(@NotNull Material material) {
        try {
            return Component.translatable(MANAGER.queryMaterial(material));
        }
        catch (Exception ex) {
            return Component.text(LocaleHelper.formatEnum(material));
        }
    }

    @NotNull
    public static String getTranslationKey(@NotNull ItemStack itemStack) {
        try {
            return MANAGER.queryMaterial(itemStack.getType(), itemStack.getDurability(), itemStack.getItemMeta());
        }
        catch (Exception ex) {
            return LocaleHelper.getTranslationKey(XMaterial.matchXMaterial(itemStack));
        }
    }

    @NotNull
    public static Component getTranslation(@NotNull ItemStack itemStack) {
        try {
            return Component.translatable(MANAGER.queryMaterial(itemStack.getType(), itemStack.getDurability(), itemStack.getItemMeta()));
        }
        catch (Exception ex) {
            return Component.text(LocaleHelper.getTranslationKey(XMaterial.matchXMaterial(itemStack)));
        }
    }

    @NotNull
    public static String getTranslationKey(@NotNull Entity entity) {
        try {
            return MANAGER.queryEntity(entity);
        }
        catch (Exception ex) {
            return LocaleHelper.formatEnum(entity.getType());
        }
    }

    @NotNull
    public static Component getTranslation(@NotNull Entity entity) {
        try {
            return Component.translatable(MANAGER.queryEntity(entity));
        }
        catch (Exception ex) {
            return Component.text(LocaleHelper.formatEnum(entity.getType()));
        }
    }

    @NotNull
    public static String getTranslationKey(@NotNull EntityType entity) {
        try {
            return MANAGER.queryEntityType(entity, null);
        }
        catch (Exception ex) {
            return LocaleHelper.formatEnum(entity);
        }
    }

    @NotNull
    public static Component getTranslation(@NotNull EntityType entity) {
        try {
            return Component.translatable(MANAGER.queryEntityType(entity, null));
        }
        catch (Exception ex) {
            return Component.text(LocaleHelper.formatEnum(entity));
        }
    }

    @NotNull
    public static String getTranslationKey(@NotNull XEnchantment enchantment) {
        try {
            String key;
            Enchantment e = enchantment.getEnchant();
            if (XMaterial.getVersion() >= 13) {
                String str = e.toString();
                key = "enchantment.minecraft." + str.substring(str.indexOf(":") + 1, str.indexOf("]")).split(", ")[0];
            } else {
                key = "enchantment." + e.getName().toLowerCase().replace("_", ".").replace("environmental", "all").replace("protection", "protect");
            }
            return key;
        }
        catch (Exception ex) {
            return LocaleHelper.formatXEnum(enchantment);
        }
    }

    @NotNull
    public static Component getTranslation(@NotNull XEnchantment enchantment) {
        try {
            return Component.translatable(LocaleHelper.getTranslationKey(enchantment));
        }
        catch (Exception ex) {
            return Component.text(LocaleHelper.formatXEnum(enchantment));
        }
    }

    @NotNull
    private static String formatEnum(@NotNull Enum<?> value) {
        return LocaleHelper.formatEnumName(value.name());
    }

    @NotNull
    private static String formatXEnum(@NotNull XModule<?, ?> value) {
        return LocaleHelper.formatEnumName(value.name());
    }

    @NotNull
    private static String formatEnumName(@NotNull String name) {
        return Stream.of(name.toLowerCase().split("_")).map(v -> v.isEmpty() ? v : Character.toUpperCase(v.charAt(0)) + (v.length() > 1 ? v.substring(1) : "")).collect(Collectors.joining(" "));
    }

    @Generated
    private LocaleHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

