/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ChatColor {
    BLACK('0'),
    DARK_BLUE('1'),
    DARK_GREEN('2'),
    DARK_AQUA('3'),
    DARK_RED('4'),
    DARK_PURPLE('5'),
    GOLD('6'),
    GRAY('7'),
    DARK_GRAY('8'),
    BLUE('9'),
    GREEN('a'),
    AQUA('b'),
    RED('c'),
    LIGHT_PURPLE('d'),
    YELLOW('e'),
    WHITE('f'),
    MAGIC('k', true),
    BOLD('l', true),
    STRIKETHROUGH('m', true),
    UNDERLINE('n', true),
    ITALIC('o', true),
    RESET('r');

    public static final ImmutableMap<String, String> CHAT_COLOR_TO_ANSI;
    private static final Pattern STRIP_COLOR_PATTERN;
    private static final Map<Character, ChatColor> BY_CHAR;
    private final char code;
    private final boolean format;

    private ChatColor(char code) {
        this(code, false);
    }

    private ChatColor(char code, boolean format) {
        this.code = code;
        this.format = format;
    }

    public boolean isColor() {
        return !this.format && this != RESET;
    }

    @Nullable
    public static ChatColor getByChar(char code) {
        return BY_CHAR.get(Character.valueOf(code));
    }

    @Nullable
    public static ChatColor getByChar(@NotNull String code) {
        return BY_CHAR.get(Character.valueOf(code.charAt(0)));
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String stripColor(@Nullable String input) {
        return input == null ? null : STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }

    @NotNull
    public static String translate(@NotNull String input) {
        return ChatColor.translate(input, '&');
    }

    @NotNull
    public static String translate(@NotNull String input, char formatChar) {
        char[] b = input.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != formatChar || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    @NotNull
    public static String translateToAnsi(@NotNull String input) {
        return ChatColor.translateToAnsi(input, false);
    }

    @NotNull
    public static String translateToAnsi(@NotNull String input, boolean format) {
        if (format) {
            input = ChatColor.translate(input);
        }
        for (Map.Entry entry : CHAT_COLOR_TO_ANSI.entrySet()) {
            input = input.replaceAll((String)entry.getKey(), (String)entry.getValue());
        }
        return input;
    }

    public String toString() {
        return "\u00a7" + this.code;
    }

    @Generated
    public char getCode() {
        return this.code;
    }

    @Generated
    public boolean isFormat() {
        return this.format;
    }

    static {
        CHAT_COLOR_TO_ANSI = ImmutableMap.builder().put((Object)"\u00a70", (Object)"\u001b[30m").put((Object)"\u00a71", (Object)"\u001b[34m").put((Object)"\u00a72", (Object)"\u001b[32m").put((Object)"\u00a73", (Object)"\u001b[36m").put((Object)"\u00a74", (Object)"\u001b[31m").put((Object)"\u00a75", (Object)"\u001b[35m").put((Object)"\u00a76", (Object)"\u001b[33m").put((Object)"\u00a77", (Object)"\u001b[37m").put((Object)"\u00a78", (Object)"\u001b[90m").put((Object)"\u00a79", (Object)"\u001b[94m").put((Object)"\u00a7a", (Object)"\u001b[92m").put((Object)"\u00a7b", (Object)"\u001b[96m").put((Object)"\u00a7c", (Object)"\u001b[91m").put((Object)"\u00a7d", (Object)"\u001b[95m").put((Object)"\u00a7e", (Object)"\u001b[93m").put((Object)"\u00a7f", (Object)"\u001b[97m").put((Object)"\u00a7l", (Object)"\u001b[1m").put((Object)"\u00a7o", (Object)"\u001b[3m").put((Object)"\u00a7n", (Object)"\u001b[4m").put((Object)"\u00a7m", (Object)"\u001b[9m").put((Object)"\u00a7k", (Object)"\u001b[6m").put((Object)"\u00a7r", (Object)"\u001b[0m").build();
        STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[\\dA-FK-OR]");
        BY_CHAR = new HashMap<Character, ChatColor>();
        for (ChatColor color : ChatColor.values()) {
            BY_CHAR.put(Character.valueOf(color.code), color);
        }
    }
}

