/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui.element;

import co.crystaldev.alpinecore.framework.config.object.item.DefinedConfigItem;
import co.crystaldev.alpinecore.framework.ui.UIContext;
import co.crystaldev.alpinecore.framework.ui.element.Element;
import co.crystaldev.alpinecore.framework.ui.element.ElementProvider;
import co.crystaldev.alpinecore.framework.ui.element.PaginatorState;
import co.crystaldev.alpinecore.framework.ui.element.type.PaginatorElement;
import co.crystaldev.alpinecore.framework.ui.element.type.PaginatorNavElement;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ElementPaginator<T> {
    private final ElementProvider<T, ?> elementProvider;
    private final Function<UIContext, ItemStack> emptySlotProvider;
    private final Map<UIContext, PaginatorState> states = new HashMap<UIContext, PaginatorState>();

    private ElementPaginator(@NotNull ElementProvider<T, ?> elementProvider, @Nullable Function<UIContext, ItemStack> emptySlotProvider) {
        this.elementProvider = elementProvider;
        this.emptySlotProvider = emptySlotProvider;
    }

    @NotNull
    public PaginatorState getOrCreateState(@NotNull UIContext context) {
        return this.states.computeIfAbsent(context, ctx -> new PaginatorState(this.elementProvider.size()));
    }

    public void initPage(@NotNull UIContext context, int page, int pageSize) {
        PaginatorState state = this.getOrCreateState(context);
        state.setPageSize(pageSize);
        state.setPage(page);
    }

    @NotNull
    public ElementProvider<T, ?> getProvider() {
        return this.elementProvider;
    }

    @NotNull
    public PaginatorElement<T> buildNextSlot(@NotNull UIContext context) {
        PaginatorState state = this.getOrCreateState(context);
        this.elementProvider.nextElement(context);
        int offset = this.elementProvider.getIndex(context) - 1;
        state.setPageSize(state.getPageSize() + 1);
        return new PaginatorElement<T>(context, this.elementProvider, this.emptySlotProvider, state, offset);
    }

    @NotNull
    public Element buildPreviousNav(@NotNull UIContext context, @NotNull DefinedConfigItem item, @Nullable DefinedConfigItem emptyItem) {
        PaginatorState state = this.getOrCreateState(context);
        return new PaginatorNavElement(context, state, -1, item, emptyItem);
    }

    @NotNull
    public Element buildPreviousNav(@NotNull UIContext context, @NotNull DefinedConfigItem item) {
        return this.buildPreviousNav(context, item, null);
    }

    @NotNull
    public Element buildNextNav(@NotNull UIContext context, @NotNull DefinedConfigItem item, @Nullable DefinedConfigItem emptyItem) {
        PaginatorState state = this.getOrCreateState(context);
        return new PaginatorNavElement(context, state, 1, item, emptyItem);
    }

    @NotNull
    public Element buildNextNav(@NotNull UIContext context, @NotNull DefinedConfigItem item) {
        return this.buildNextNav(context, item, null);
    }

    @NotNull
    public Element buildNavInfo(@NotNull UIContext context, @NotNull DefinedConfigItem item, @Nullable DefinedConfigItem emptyItem) {
        PaginatorState state = this.getOrCreateState(context);
        return new PaginatorNavElement(context, state, 0, item, emptyItem);
    }

    @NotNull
    public Element buildNavInfo(@NotNull UIContext context, @NotNull DefinedConfigItem item) {
        return this.buildNavInfo(context, item, null);
    }

    public void closed(@NotNull UIContext context) {
        this.closed(context, true);
    }

    public void closed(@NotNull UIContext context, boolean clearState) {
        this.elementProvider.closed(context);
        if (clearState) {
            PaginatorState state = this.states.get(context);
            if (state != null) {
                state.resetPageSize();
            }
            this.states.entrySet().removeIf(e -> ((UIContext)e.getKey()).isStale());
        }
    }

    @NotNull
    public static <S> ElementPaginator<S> from(@NotNull ElementProvider<S, ?> elementProvider) {
        return new ElementPaginator<S>(elementProvider, null);
    }

    @NotNull
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<T> {
        private ElementProvider<T, ?> elementProvider;
        private Function<UIContext, ItemStack> emptySlotProvider;

        @NotNull
        public Builder<T> elementProvider(@NotNull ElementProvider<T, ?> elementProvider) {
            this.elementProvider = elementProvider;
            return this;
        }

        @NotNull
        public Builder<T> emptySlotProvider(@Nullable Function<UIContext, ItemStack> emptySlotProvider) {
            this.emptySlotProvider = emptySlotProvider;
            return this;
        }

        @NotNull
        public ElementPaginator<T> build() {
            Validate.notNull(this.elementProvider, (String)"elementProvider cannot be null");
            return new ElementPaginator(this.elementProvider, this.emptySlotProvider);
        }
    }
}

