/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.plugin.events;

import de.rayzs.controlplayer.api.control.ControlInstance;
import de.rayzs.controlplayer.api.control.ControlManager;
import de.rayzs.controlplayer.api.control.ControlSwap;
import de.rayzs.controlplayer.api.files.settings.SettingType;
import de.rayzs.controlplayer.api.files.settings.SettingsManager;
import de.rayzs.controlplayer.plugin.ControlPlayerPlugin;
import java.util.Arrays;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PlayerTeleport
implements Listener {
    private final ControlPlayerPlugin instance = ControlPlayerPlugin.getInstance();

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        boolean useSwap;
        if (!((Boolean)SettingsManager.getSetting(SettingType.CONTROL_RUNNING_SYNCTELEPORT)).booleanValue()) {
            return;
        }
        Player victim = event.getPlayer();
        ControlInstance instance = ControlManager.getControlInstance(victim);
        if (instance == null || event.getTo() == null) {
            return;
        }
        Location toLoc = event.getTo();
        Location fromLoc = event.getFrom();
        ControlSwap swap = ControlManager.getControlSwap(instance);
        int instanceState = ControlManager.getInstanceState(victim);
        boolean bl = useSwap = swap.isEnabled() && swap.isSwapped();
        if (event.getTo() == null || useSwap || instanceState == 0) {
            return;
        }
        if (!Arrays.asList(PlayerTeleportEvent.TeleportCause.COMMAND, PlayerTeleportEvent.TeleportCause.PLUGIN).contains(event.getCause())) {
            return;
        }
        Player controller = instance.controller();
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN) {
            if (fromLoc.distance(toLoc) < 5.0) {
                return;
            }
            controller.teleport(victim.getLocation());
            event.setCancelled(true);
            return;
        }
        controller.teleport(victim.getLocation());
        event.setCancelled(true);
    }
}

