/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.plugin.events;

import de.rayzs.controlplayer.api.control.ControlInstance;
import de.rayzs.controlplayer.api.control.ControlManager;
import de.rayzs.controlplayer.api.control.ControlSwap;
import de.rayzs.controlplayer.api.packetbased.animation.ArmSwingAnimation;
import de.rayzs.controlplayer.api.utils.ExpireList;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;

public class PlayerInteractAtEntity
extends ArmSwingAnimation
implements Listener {
    private final ExpireList<Player> delayedPlayers = new ExpireList(10L, TimeUnit.MILLISECONDS);

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        boolean useSwap;
        Player player = event.getPlayer();
        ControlInstance instance = ControlManager.getControlInstance(player);
        if (instance == null) {
            return;
        }
        ControlSwap swap = ControlManager.getControlSwap(instance);
        int instanceState = ControlManager.getInstanceState(player);
        boolean bl = useSwap = swap.isEnabled() && swap.isSwapped();
        if (useSwap && instanceState == 0 || !useSwap && instanceState == 1) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteractAtEntity(PlayerInteractEntityEvent event) {
        boolean useSwap;
        Player player = event.getPlayer();
        ControlInstance instance = ControlManager.getControlInstance(player);
        if (instance == null) {
            return;
        }
        ControlSwap swap = ControlManager.getControlSwap(instance);
        int instanceState = ControlManager.getInstanceState(player);
        boolean bl = useSwap = swap.isEnabled() && swap.isSwapped();
        if (useSwap && instanceState == 0 || !useSwap && instanceState == 1) {
            event.setCancelled(true);
            return;
        }
        if ((useSwap && instanceState == 1 || !useSwap && instanceState == 0) && event.getRightClicked() instanceof Sittable && event.getRightClicked() instanceof Tameable) {
            Entity clickedEntity = event.getRightClicked();
            Tameable tameable = (Tameable)clickedEntity;
            Sittable sittable = (Sittable)clickedEntity;
            if (!tameable.isTamed() || tameable.getOwner() == null || tameable.getOwner().getName() == null) {
                return;
            }
            ControlInstance controlInstance = ControlManager.getControlInstance(player);
            if (controlInstance == null) {
                return;
            }
            if (!tameable.getOwner().getName().equalsIgnoreCase(controlInstance.victim().getName())) {
                return;
            }
            if (this.delayedPlayers.contains(player)) {
                return;
            }
            this.delayedPlayers.addIgnoreIfContains(player);
            sittable.setSitting(!sittable.isSitting());
            this.execute(instance.victim(), "");
            this.execute(instance.controller(), "");
        }
    }
}

