/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.plugin.events;

import de.rayzs.controlplayer.api.control.ControlInstance;
import de.rayzs.controlplayer.api.control.ControlManager;
import de.rayzs.controlplayer.api.control.ControlSwap;
import de.rayzs.controlplayer.plugin.ControlPlayerPlugin;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.plugin.Plugin;

public class InventoryInteraction
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryClick(InventoryClickEvent event) {
        boolean useSwap;
        if (!(event.getWhoClicked() instanceof Player) || event.isCancelled()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ControlInstance instance = ControlManager.getControlInstance(player);
        if (instance == null) {
            return;
        }
        ControlSwap swap = ControlManager.getControlSwap(instance);
        int instanceState = ControlManager.getInstanceState(player);
        boolean bl = useSwap = swap.isEnabled() && swap.isSwapped();
        if (useSwap && instanceState == 0 || !useSwap && instanceState == 1) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryDrag(InventoryDragEvent event) {
        boolean useSwap;
        if (!(event.getWhoClicked() instanceof Player) || event.isCancelled()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ControlInstance instance = ControlManager.getControlInstance(player);
        if (instance == null) {
            return;
        }
        ControlSwap swap = ControlManager.getControlSwap(instance);
        int instanceState = ControlManager.getInstanceState(player);
        boolean bl = useSwap = swap.isEnabled() && swap.isSwapped();
        if (useSwap && instanceState == 0 || !useSwap && instanceState == 1) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryOpen(InventoryOpenEvent event) {
        boolean useSwap;
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        ControlInstance instance = ControlManager.getControlInstance(player);
        if (instance == null) {
            return;
        }
        ControlSwap swap = ControlManager.getControlSwap(instance);
        int instanceState = ControlManager.getInstanceState(player);
        boolean bl = useSwap = swap.isEnabled() && swap.isSwapped();
        if (useSwap && instanceState == 0 || !useSwap && instanceState == 1) {
            return;
        }
        Player victim = instance.victim();
        if (player != victim) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)ControlPlayerPlugin.getInstance(), () -> victim.openInventory(event.getInventory()));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryClose(InventoryCloseEvent event) {
        String openInventoryType;
        boolean useSwap;
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        ControlInstance instance = ControlManager.getControlInstance(player);
        if (instance == null) {
            return;
        }
        ControlSwap swap = ControlManager.getControlSwap(instance);
        int instanceState = ControlManager.getInstanceState(player);
        boolean bl = useSwap = swap.isEnabled() && swap.isSwapped();
        if (useSwap && instanceState == 0 || !useSwap && instanceState == 1) {
            Player controller;
            String controllerOpenInventory;
            String openInventoryType2 = event.getInventory().getType().name();
            if (!(openInventoryType2.contains("CRAFTING") || openInventoryType2.contains("CREATIVE") || (controllerOpenInventory = (controller = useSwap ? instance.victim() : instance.controller()).getOpenInventory().getType().name()).contains("CRAFTING") || controllerOpenInventory.contains("CREATIVE"))) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)ControlPlayerPlugin.getInstance(), () -> {
                    player.teleport((Entity)controller);
                    player.openInventory(event.getInventory());
                });
            }
            return;
        }
        Player victim = instance.victim();
        if (player != victim && !(openInventoryType = event.getInventory().getType().name()).contains("CRAFTING") && !openInventoryType.contains("CREATIVE")) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)ControlPlayerPlugin.getInstance(), () -> ((Player)victim).closeInventory());
        }
    }
}

