/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.plugin.events;

import de.rayzs.controlplayer.api.control.ControlInstance;
import de.rayzs.controlplayer.api.control.ControlManager;
import de.rayzs.controlplayer.api.control.ControlSwap;
import de.rayzs.controlplayer.plugin.ControlPlayerPlugin;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityDamageByEntity
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        int instanceState;
        Player player;
        if (event.isCancelled()) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            player = (Player)event.getDamager();
            instanceState = ControlManager.getInstanceState(player);
            ControlInstance instance = ControlManager.getControlInstance(player);
            if (instanceState == 1) {
                event.setCancelled(true);
                return;
            }
            if (instanceState == 0) {
                if (instance.victim() == player) {
                    return;
                }
                Player victim = instance.victim();
                if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).getHealth() - event.getDamage() < 0.5) {
                    event.setCancelled(true);
                    player.damage(event.getDamage(), (Entity)victim);
                }
            }
        }
        if (event.getEntity() instanceof Player) {
            ControlInstance controlInstance;
            player = (Player)event.getEntity();
            instanceState = ControlManager.getInstanceState(player);
            if (instanceState == 1) {
                controlInstance = ControlManager.getControlInstance(player);
                Player controller = controlInstance.controller();
                event.setCancelled(false);
                if (!event.isCancelled()) {
                    this.pushPlayer((Entity)controller, event.getDamager());
                }
                Player finalPlayer = player;
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)ControlPlayerPlugin.getInstance(), () -> {
                    if (finalPlayer.getHealth() < 0.5) {
                        return;
                    }
                    controller.setHealth(finalPlayer.getHealth());
                });
            } else if (instanceState == 0) {
                double healthAfterDamage;
                controlInstance = ControlManager.getControlInstance(player);
                if (!event.isCancelled()) {
                    ControlSwap swap = ControlManager.getControlSwap(controlInstance);
                    this.pushPlayer((Entity)(swap.isSwapped() ? controlInstance.victim() : controlInstance.controller()), event.getDamager());
                }
                if ((healthAfterDamage = player.getHealth() - event.getDamage()) < 0.5) {
                    Player victim = controlInstance.victim();
                    event.setCancelled(true);
                    victim.damage(event.getDamage(), event.getDamager());
                }
            }
        }
    }

    private void pushPlayer(Entity victim, Entity attacker) {
        Vector vector = new Vector(0.0, -0.078375, 0.0);
        if (attacker != null) {
            Player attackerAsPlayer;
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            Location victimLocation = victim.getLocation();
            Location attackerLocation = attacker.getLocation();
            double deltaX = victimLocation.getX() - attackerLocation.getX();
            double deltaZ = victimLocation.getZ() - attackerLocation.getZ();
            double y = 0.36075;
            while (deltaX * deltaX + deltaZ * deltaZ < 1.0E-4) {
                deltaX = threadLocalRandom.nextDouble() - threadLocalRandom.nextDouble() * 0.01;
                deltaZ = threadLocalRandom.nextDouble() - threadLocalRandom.nextDouble() * 0.01;
            }
            double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            deltaX = deltaX / distance * 0.4;
            deltaZ = deltaZ / distance * 0.4;
            if (attacker instanceof Player && !(attackerAsPlayer = (Player)attacker).isSneaking()) {
                double yaw = (double)attackerLocation.getYaw() * Math.PI / 180.0;
                deltaX += -Math.sin(yaw) * 1.5;
                deltaZ = Math.cos(yaw) * 1.5;
                y += 0.1;
                deltaX *= 0.6;
                deltaZ *= 0.6;
            }
            vector = new Vector(deltaX, y, deltaZ);
        }
        victim.setVelocity(vector);
    }
}

