/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.plugin.commands;

import de.rayzs.controlplayer.api.files.settings.SettingType;
import de.rayzs.controlplayer.api.files.settings.SettingsManager;
import de.rayzs.controlplayer.api.hierarchy.HierarchyManager;
import de.rayzs.controlplayer.api.specific.SpecificControlManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ControlPlayerTabCompleter {
    public static List<String> getTabCompletion(CommandSender sender, String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (!(sender instanceof Player) || args.length > 1) {
            return results;
        }
        Player executor = (Player)sender;
        boolean specific = SpecificControlManager.doesPlayerHaveSpecificControlPerms(executor);
        if (sender.isOp() || sender.hasPermission("controlplayer.use") || specific) {
            Bukkit.getOnlinePlayers().stream().filter(player -> {
                if (player.getName().equals(sender.getName())) {
                    return false;
                }
                if (specific && !SpecificControlManager.canPlayerControl(executor, player)) {
                    return false;
                }
                if (!((Boolean)SettingsManager.getSetting(SettingType.SYSTEM_IGNOREBYPASS)).booleanValue()) {
                    return !player.isOp() && (HierarchyManager.isHigher(executor, player) || SpecificControlManager.canPlayerControl(executor, player));
                }
                return true;
            }).forEach(player -> results.add(player.getName()));
        }
        return results.stream().filter(suggestion -> suggestion.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
    }
}

