/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.plugin.commands;

import de.rayzs.controlplayer.api.control.ControlManager;
import de.rayzs.controlplayer.api.control.ControlState;
import de.rayzs.controlplayer.api.files.messages.MessageManager;
import de.rayzs.controlplayer.api.files.messages.MessageType;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ControlPlayerOtherCommand
extends Command {
    public ControlPlayerOtherCommand(String name, String description, String usageMessage, List<String> aliases) {
        super(name, description, usageMessage, aliases);
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!sender.isOp() && !sender.hasPermission("controlplayer.other")) {
            sender.sendMessage(MessageManager.getMessage(MessageType.NO_PERMISSION));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(MessageManager.getMessage(MessageType.OTHER_USAGE));
            return true;
        }
        Player controller = Bukkit.getPlayer((String)args[0]);
        Player victim = Bukkit.getPlayer((String)args[1]);
        if (controller == null) {
            sender.sendMessage(MessageManager.getMessage(MessageType.OTHER_OFFLINE).replace("%player%", args[0]));
            return true;
        }
        int instanceId = ControlManager.getInstanceState(controller);
        if (instanceId == 0) {
            if (ControlManager.deleteControlInstance(controller)) {
                sender.sendMessage(MessageManager.getMessage(MessageType.OTHER_STOPPED).replace("%player%", controller.getName()));
            }
            return true;
        }
        if (victim == null) {
            sender.sendMessage(MessageManager.getMessage(MessageType.OTHER_OFFLINE).replace("%player%", args[1]));
            return true;
        }
        if (controller == victim) {
            sender.sendMessage(MessageManager.getMessage(MessageType.OTHER_SAME).replace("%player%", args[0]));
            return true;
        }
        if (controller.isDead()) {
            sender.sendMessage(MessageManager.getMessage(MessageType.OTHER_DEAD).replace("%player%", controller.getName()));
            return true;
        }
        if (victim.isDead()) {
            sender.sendMessage(MessageManager.getMessage(MessageType.OTHER_DEAD).replace("%player%", victim.getName()));
            return true;
        }
        int victimInstanceId = ControlManager.getInstanceState(victim);
        if (instanceId == 1) {
            sender.sendMessage(MessageManager.getMessage(MessageType.OTHER_ALREADY_CONTROLLED).replace("%player%", controller.getName()));
            return true;
        }
        if (victimInstanceId == 1) {
            sender.sendMessage(MessageManager.getMessage(MessageType.OTHER_ALREADY_CONTROLLED).replace("%player%", victim.getName()));
            return true;
        }
        ControlState state = ControlManager.createControlInstance(controller, victim, false);
        if (state != ControlState.SUCCESS) {
            return true;
        }
        sender.sendMessage(MessageManager.getMessage(MessageType.OTHER_SUCCESS).replace("%player%", controller.getName()).replace("%victim%", victim.getName()));
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        List suggestions = Bukkit.getOnlinePlayers().stream().filter(player -> {
            int instanceId = ControlManager.getInstanceState(player);
            return instanceId == -1;
        }).map(OfflinePlayer::getName).collect(Collectors.toList());
        if (args.length >= 1) {
            suggestions.remove(args[0]);
        }
        return suggestions.stream().filter(suggestion -> suggestion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

