/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.plugin.commands;

import de.rayzs.controlplayer.api.control.ControlManager;
import de.rayzs.controlplayer.api.files.messages.MessageManager;
import de.rayzs.controlplayer.api.files.messages.MessageType;
import de.rayzs.controlplayer.plugin.commands.ControlPlayerTabCompleter;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ControlPlayerFixCommand
extends Command {
    public ControlPlayerFixCommand(String name, String description, String usageMessage, List<String> aliases) {
        super(name, description, usageMessage, aliases);
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        String targetName;
        if (!sender.isOp() && !sender.hasPermission("controlplayer.fix")) {
            sender.sendMessage(MessageManager.getMessage(MessageType.NO_PERMISSION));
            return true;
        }
        String string = args.length > 0 ? args[0] : (targetName = sender instanceof Player ? "-2" : "-1");
        if (targetName.equals("-1")) {
            sender.sendMessage(MessageManager.getMessage(MessageType.ONLY_PLAYERS));
            return true;
        }
        Player target = Bukkit.getPlayer((String)(targetName.equals("-2") ? sender.getName() : targetName));
        if (target == null) {
            sender.sendMessage(MessageManager.getMessage(MessageType.NOT_ONLINE));
            return true;
        }
        if (ControlManager.getInstanceState(target) != -1) {
            if (targetName.equals("-2")) {
                sender.sendMessage(MessageManager.getMessage(MessageType.PREFIX) + "\u00a7cYou are being controlled or controlling someone at the moment!");
            } else {
                sender.sendMessage(MessageManager.getMessage(MessageType.PREFIX) + "\u00a7cThis player is being controlled or is controlling someone at the moment!");
            }
            return true;
        }
        target.setHealthScale(100.0);
        target.setHealth(20.0);
        ControlManager.fixPlayer(target);
        sender.sendMessage(MessageManager.getMessage(MessageType.PREFIX) + " \u00a7aFixed " + (targetName.equals("-2") ? "yourself" : target.getName()) + "!");
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        return ControlPlayerTabCompleter.getTabCompletion(sender, args);
    }
}

