/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.plugin;

import de.rayzs.controlplayer.api.adapter.LuckPermsAdapter;
import de.rayzs.controlplayer.api.control.ControlManager;
import de.rayzs.controlplayer.api.files.settings.SettingType;
import de.rayzs.controlplayer.api.files.settings.SettingsManager;
import de.rayzs.controlplayer.api.hierarchy.HierarchyManager;
import de.rayzs.controlplayer.api.specific.SpecificControlManager;
import de.rayzs.controlplayer.api.version.ServerVersion;
import de.rayzs.controlplayer.api.web.WebConnection;
import de.rayzs.controlplayer.plugin.bstats.Metrics;
import de.rayzs.controlplayer.plugin.commands.ControlPlayerCommand;
import de.rayzs.controlplayer.plugin.commands.ControlPlayerFixCommand;
import de.rayzs.controlplayer.plugin.commands.ControlPlayerOtherCommand;
import de.rayzs.controlplayer.plugin.commands.ControlPlayerReloadCommand;
import de.rayzs.controlplayer.plugin.commands.ControlPlayerStopCommand;
import de.rayzs.controlplayer.plugin.commands.SilentControlPlayerCommand;
import de.rayzs.controlplayer.plugin.events.BlockBreak;
import de.rayzs.controlplayer.plugin.events.BlockPlace;
import de.rayzs.controlplayer.plugin.events.EntityDamage;
import de.rayzs.controlplayer.plugin.events.EntityDamageByEntity;
import de.rayzs.controlplayer.plugin.events.EntityTargetLivingEntity;
import de.rayzs.controlplayer.plugin.events.InventoryInteraction;
import de.rayzs.controlplayer.plugin.events.PlayerAchievement;
import de.rayzs.controlplayer.plugin.events.PlayerAnimation;
import de.rayzs.controlplayer.plugin.events.PlayerChangeWorld;
import de.rayzs.controlplayer.plugin.events.PlayerChat;
import de.rayzs.controlplayer.plugin.events.PlayerCommandPreProcess;
import de.rayzs.controlplayer.plugin.events.PlayerDeath;
import de.rayzs.controlplayer.plugin.events.PlayerDropItem;
import de.rayzs.controlplayer.plugin.events.PlayerInteract;
import de.rayzs.controlplayer.plugin.events.PlayerInteractAtEntity;
import de.rayzs.controlplayer.plugin.events.PlayerJoin;
import de.rayzs.controlplayer.plugin.events.PlayerPickupItem;
import de.rayzs.controlplayer.plugin.events.PlayerQuit;
import de.rayzs.controlplayer.plugin.events.PlayerTeleport;
import de.rayzs.controlplayer.plugin.events.PlayerToggleFlight;
import de.rayzs.controlplayer.plugin.events.PlayerToggleSneak;
import de.rayzs.controlplayer.plugin.events.PlayerToggleSprint;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ControlPlayerPlugin
extends JavaPlugin {
    private static ControlPlayerPlugin instance;
    private boolean latestVersion = true;
    private int updaterTaskId;
    private final WebConnection web = new WebConnection();
    private static final List<Command> registeredCommands;
    private static CommandMap commandMap;
    private final Class<?>[] listenerClasses = new Class[]{PlayerChangeWorld.class, PlayerDeath.class, PlayerInteract.class, PlayerInteractAtEntity.class, PlayerAnimation.class, EntityDamage.class, EntityDamageByEntity.class, EntityTargetLivingEntity.class, PlayerToggleFlight.class, PlayerToggleSneak.class, PlayerToggleSprint.class, PlayerPickupItem.class, PlayerDropItem.class, InventoryInteraction.class, PlayerJoin.class, PlayerQuit.class, BlockBreak.class, BlockPlace.class, PlayerChat.class, PlayerCommandPreProcess.class, PlayerTeleport.class};

    public void onEnable() {
        instance = this;
        ControlManager.load((Plugin)this);
        this.accessSimpleCommandMap();
        this.startUpdaterTask();
        ControlPlayerPlugin.registerCommands();
        this.registerEvents();
        new Metrics(this, 15651);
        if (Bukkit.getServer().getPluginManager().getPlugin("LuckPerms") != null) {
            LuckPermsAdapter.initialize();
            HierarchyManager.initialize();
            SpecificControlManager.initialize();
        }
    }

    public void onDisable() {
        ControlPlayerPlugin.unregisterCommands();
    }

    public static ControlPlayerPlugin getInstance() {
        return instance;
    }

    public boolean isLatestVersion() {
        return this.latestVersion;
    }

    public static void registerCommands() {
        ControlPlayerPlugin.registerCommand(new ControlPlayerCommand("controlplayer", "Take full control over a player", "/controlplayer <player>", (ArrayList)SettingsManager.getSetting(SettingType.COMMANDALIASES_CONTROL)));
        ControlPlayerPlugin.registerCommand(new ControlPlayerStopCommand("controlplayerstop", "Force someone to stop controlling", "/controlplayerstop <controller>", Arrays.asList("cps", "cpstop")));
        ControlPlayerPlugin.registerCommand(new ControlPlayerOtherCommand("controlplayerother", "Force someone to control another player", "/controlplayerother <controller> <victim>", Arrays.asList("cpo", "cpother")));
        ControlPlayerPlugin.registerCommand(new SilentControlPlayerCommand("silentcontrolplayer", "Activate the toggle-mode to control a player", "/silentcontrolmode <player>", (ArrayList)SettingsManager.getSetting(SettingType.COMMANDALIASES_SILENTCONTROL)));
        ControlPlayerPlugin.registerCommand(new ControlPlayerReloadCommand("controlplayerreload", "Reload all files", "/controlplayerreload", (ArrayList)SettingsManager.getSetting(SettingType.COMMANDALIASES_RELOAD)));
        ControlPlayerPlugin.registerCommand(new ControlPlayerFixCommand("controlplayerfix", "Fix players or yourself", "/controlplayerfix <optional: player>", (ArrayList)SettingsManager.getSetting(SettingType.COMMANDALIASES_FIX)));
    }

    public static void unregisterCommands() {
        if (commandMap == null) {
            return;
        }
        for (Command command : registeredCommands) {
            command.unregister(commandMap);
        }
    }

    protected void registerEvents() {
        for (Class<?> clazz : this.listenerClasses) {
            try {
                Listener listener = (Listener)clazz.newInstance();
                this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
            }
            catch (IllegalAccessException | InstantiationException exception) {
                this.getLogger().warning("Could not register the listener-class [" + clazz.getSimpleName() + "]!");
                this.getLogger().warning("Error message:");
                exception.printStackTrace();
            }
        }
        if (ServerVersion.getInstance().getMinor() >= 18) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerAchievement(), (Plugin)this);
        }
    }

    protected static void registerCommand(Command command) {
        registeredCommands.add(command);
        commandMap.register(command.getName(), command);
    }

    protected void accessSimpleCommandMap() {
        try {
            Class clazz = Bukkit.getServer().getClass();
            Field field = clazz.getDeclaredField("commandMap");
            field.setAccessible(true);
            commandMap = (CommandMap)field.get(Bukkit.getServer());
        }
        catch (Throwable throwable) {
            this.getLogger().warning("Could not access CommandMap!");
        }
    }

    protected void startUpdaterTask() {
        boolean update;
        Object updateObject = SettingsManager.getSetting(SettingType.UPDATER_ENABLED);
        boolean bl = update = updateObject == null || (Boolean)updateObject != false;
        if (!update) {
            return;
        }
        Object delayObject = SettingsManager.getSetting(SettingType.UPDATER_DELAY);
        int delay = delayObject == null ? 18000 : (Integer)delayObject;
        this.updaterTaskId = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)this, () -> {
            String result = this.web.connect("https://www.rayzs.de/products/controlplayer/version/version.txt").getResult();
            if (!result.equals(this.getDescription().getVersion())) {
                Bukkit.getScheduler().cancelTask(this.updaterTaskId);
                if (result.equals("unknown")) {
                    this.getLogger().warning("Failed reaching web host! (firewall enabled? website down?)");
                } else if (result.equals("exception")) {
                    this.getLogger().warning("Failed creating web instance! (outdated java version?)");
                } else {
                    this.getLogger().warning("You're using an outdated version of this plugin!");
                    this.getLogger().warning("Please update it on: https://www.rayzs.de/products/controlplayer/page");
                }
                this.latestVersion = false;
            }
        }, 20L, (long)delay);
    }

    static {
        registeredCommands = new ArrayList<Command>();
        commandMap = null;
    }
}

