/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.api.version;

import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Server;

public class ServerVersion {
    public static ServerVersion INSTANCE;
    private Version version;
    private boolean legacy;
    private boolean folia;
    private String versionName;
    private String versionPackageName;
    private String rawVersionName;
    private int major;
    private int minor;
    private int release;

    public ServerVersion(Server server) {
        INSTANCE = this;
        try {
            Class.forName("org.bukkit.Server");
            this.loadVersionName(server);
            this.loadAges();
            this.loadVersionEnum();
            this.legacy = this.minor <= 16;
            try {
                Class.forName("com.destroystokyo.paper.proxy.VelocityProxy");
                this.folia = this.versionName.toLowerCase().contains("folia");
            }
            catch (Throwable throwable) {
                this.folia = false;
            }
        }
        catch (Throwable ignored) {
            System.err.println("Could not read server version!");
        }
    }

    public static ServerVersion getInstance() {
        return INSTANCE;
    }

    public boolean isFolia() {
        return this.folia;
    }

    public boolean isModern() {
        return !this.legacy;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public String getRawVersionName() {
        return this.rawVersionName;
    }

    private void loadVersionName(Object serverObject) throws Exception {
        this.versionName = Bukkit.getName();
        this.rawVersionName = (String)serverObject.getClass().getMethod("getBukkitVersion", new Class[0]).invoke(serverObject, new Object[0]);
        this.rawVersionName = this.rawVersionName.split("-")[0].replace(".", "_");
        this.versionPackageName = serverObject.getClass().getPackage().getName();
        this.versionPackageName = this.versionPackageName.substring(this.versionPackageName.lastIndexOf(46) + 1);
    }

    private void loadVersionEnum() {
        try {
            StringBuilder builder = new StringBuilder("v_");
            builder.append(this.major).append("_").append(this.minor);
            String primaryVersionName = builder.toString();
            if (this.release != 0) {
                builder.append("_").append(this.release);
            }
            String fullVersionName = builder.toString();
            boolean couldFindOriginalVersion = Arrays.stream(Version.values()).anyMatch(searchingVersion -> searchingVersion.toString().equals(fullVersionName));
            this.version = Version.valueOf(couldFindOriginalVersion ? fullVersionName : primaryVersionName);
        }
        catch (Exception exception) {
            this.version = Version.UNSUPPORTED;
        }
    }

    private void loadAges() {
        String[] versionArgs = this.rawVersionName.split("_");
        this.major = Integer.parseInt(versionArgs[0]);
        this.minor = Integer.parseInt(versionArgs[1]);
        this.release = versionArgs.length > 2 ? Integer.parseInt(versionArgs[2]) : 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRelease() {
        return this.release;
    }

    public static enum Version {
        UNKNOWN,
        UNSUPPORTED,
        v_1_8,
        v_1_8_8,
        v_1_9,
        v_1_9_4,
        v_1_10,
        v_1_10_2,
        v_1_11,
        v_1_11_2,
        v_1_12,
        v_1_12_2,
        v_1_13,
        v_1_13_2,
        v_1_14,
        v_1_14_4,
        v_1_15,
        v_1_15_2,
        v_1_16,
        v_1_16_4,
        v_1_16_5,
        v_1_17,
        v_1_17_1,
        v_1_18,
        v_1_18_1,
        v_1_18_2,
        v_1_19,
        v_1_19_1,
        v_1_19_2,
        v_1_19_3,
        v_1_19_4,
        v_1_20,
        v_1_20_1,
        v_1_20_2,
        v_1_20_3,
        v_1_20_4,
        v_1_20_5,
        v_1_20_6,
        v_1_21,
        v_1_21_1,
        v_1_21_2;

    }
}

