/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.api.packetbased.animation.impl;

import de.rayzs.controlplayer.api.packetbased.animation.ArmSwing;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class LegacyArmSwingAnimation
implements ArmSwing {
    private final String versionName;
    private boolean disableArmSwing = false;

    public LegacyArmSwingAnimation(String versionName) {
        this.versionName = versionName;
    }

    @Override
    public void execute(Player player, String armSwingAnimationType) {
        if (this.disableArmSwing || player == null) {
            return;
        }
        try {
            Class<?> entityClass = Class.forName("net.minecraft.server." + this.versionName + ".Entity");
            Object entityTargetPlayer = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Object animationPacket = Class.forName("net.minecraft.server." + this.versionName + ".PacketPlayOutAnimation").getDeclaredConstructor(entityClass, Integer.TYPE).newInstance(entityTargetPlayer, 0);
            Bukkit.getOnlinePlayers().forEach(players -> {
                try {
                    Object entityPlayer = players.getClass().getMethod("getHandle", new Class[0]).invoke(players, new Object[0]);
                    Object playerConnection = entityPlayer.getClass().getField("playerConnection").get(entityPlayer);
                    playerConnection.getClass().getMethod("sendPacket", Class.forName("net.minecraft.server." + this.versionName + ".Packet")).invoke(playerConnection, animationPacket);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            });
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            System.err.println("Disabled ArmSwingAnimations because this version isn't is supported!");
            this.disableArmSwing = true;
        }
    }
}

