/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.api.files.settings;

import de.rayzs.controlplayer.api.configurator.FileConfigurator;
import de.rayzs.controlplayer.api.files.settings.SettingType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class SettingsManager {
    private static FileConfigurator FILE = new FileConfigurator("config", "./plugins/ControlPlayer");
    private static final HashMap<SettingType, Object> SETTINGS = new HashMap();
    private static final String SETTING_PATH = "settings.";

    public static void reload(boolean firstLoad) {
        SettingType[] settingTypes;
        if (!firstLoad) {
            FILE = new FileConfigurator("config", "./plugins/ControlPlayer");
            SETTINGS.clear();
        }
        for (SettingType settingType : settingTypes = SettingType.values()) {
            Object obj;
            String settingPath = SETTING_PATH + settingType.toString().toLowerCase().replace("_", ".");
            if (FILE.loadDefault()) {
                SettingsManager.setSettingToFile(settingType);
            }
            if ((obj = FILE.get(settingPath)) == null) {
                System.out.println("Resetted '" + settingPath + "' from " + FILE.getFile().getName() + " because the value is null!");
                SettingsManager.setSettingToFile(settingType);
                obj = FILE.get(settingPath);
            }
            SETTINGS.put(settingType, obj);
        }
    }

    public static Object getSetting(SettingType settingType) {
        return SETTINGS.get((Object)settingType);
    }

    protected static void setSettingToFile(SettingType settingType) {
        String defaultPath = SETTING_PATH + settingType.toString().toLowerCase().replace("_", ".");
        switch (settingType) {
            case APIMODE: 
            case SYSTEM_ASYNCCHAT: 
            case SYSTEM_IGNOREBYPASS: 
            case CONTROL_RUNNING_CANCELCHAT: 
            case CONTROL_RUNNING_CANCELCOMMANDS: 
            case CONTROL_RUNNING_SYNCTELEPORT: {
                FILE.set(defaultPath, false);
                break;
            }
            case UPDATER_DELAY: {
                FILE.set(defaultPath, 18000);
                break;
            }
            case CONTROL_RUNNING_SYNCDELAY: {
                FILE.set(defaultPath, 0);
                break;
            }
            case CONTROL_RUNNING_FORCECHAT_BYPASSMESSAGE: {
                FILE.set(defaultPath, "-b ");
                break;
            }
            case COMMANDALIASES_CONTROL: {
                FILE.set(defaultPath, SettingsManager.createArraylist("cp", "cplayer", "controlp", "control"));
                break;
            }
            case COMMANDALIASES_SILENTCONTROL: {
                FILE.set(defaultPath, SettingsManager.createArraylist("scp", "scontrolplayer", "scplayer"));
                break;
            }
            case COMMANDALIASES_RELOAD: {
                FILE.set(defaultPath, SettingsManager.createArraylist("cpr", "controlplayerr", "cpreload"));
                break;
            }
            case COMMANDALIASES_FIX: {
                FILE.set(defaultPath, SettingsManager.createArraylist("cpf", "controlplayerf", "cpfix"));
                break;
            }
            default: {
                FILE.set(defaultPath, true);
            }
        }
        FILE.save();
    }

    private static ArrayList<String> createArraylist(String ... inputs) {
        return new ArrayList<String>(Arrays.asList(inputs));
    }

    static {
        SettingsManager.reload(true);
    }
}

